package com.simm.exhibitor.export;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.basic.HallAreaDivide;

import java.util.List;

/**
 * @author liutao
 * @since 2022/12/15
 *  展馆划分外部接口
 */
public interface HallAreaDivideExport {

    /**
     * 展馆划分分页查询
     * @param hallAreaDivide 查询条件
     * @return 展馆划分分页对象
     */
    PageInfo<HallAreaDivide> page(HallAreaDivide hallAreaDivide);

    /**
     * 更新
     * @param hallAreaDivide 展馆划分对象
     * @return true or false
     */
    boolean update(HallAreaDivide hallAreaDivide);

    /**
     * 保存
     * @param hallAreaDivide 展馆划分对象
     * @return true or false
     */
    boolean save(HallAreaDivide hallAreaDivide);

    /**
     * 根据Id查询
     * @param id id
     * @return 展馆划分对象
     */
    HallAreaDivide findById(Integer id);

    /**
     * 查询所有展馆划分记录
     * @param hallAreaDivide {@link HallAreaDivide}
     * @return  展馆划分列表
     */
    List<HallAreaDivide> list(HallAreaDivide hallAreaDivide);
}
