package com.simm.exhibitor.vo.shipment;

import com.simm.exhibitor.bean.shipment.ShipmentDeclareDiscount;
import com.simm.exhibitor.bean.shipment.ShipmentDeclareExhibit;
import com.simm.exhibitor.bean.shipment.ShipmentDeclareService;
import com.simm.exhibitor.bean.shipment.ShipmentReviewExhibit;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author liutao
 * @since 2024/8/1
 */
@Data
public class ShipmentAmountVO implements Serializable {

    /**
     * id
     */
    private Integer id;

    /**
     * 展商id
     */
    private String uniqueId;

    /**
     * 订单id
     */
    private Integer orderId;

    /**
     * 包装类型(1:包装,2:裸机)
     */
    private Integer packageType;

    /**
     * 空箱体积(cm³)
     */
    private BigDecimal packageVolume;

    /**
     * 空箱存储天数
     */
    private Integer storageDays;

    /**
     * 是否按重量收费
     */
    private Boolean weightBilling;

    /**
     * 展品长(单位:cm)
     */
    private Integer len;

    /**
     * 展品宽(单位:cm)
     */
    private Integer width;

    /**
     * 展品高(单位:cm)
     */
    private Integer height;

    /**
     * 展品体积(cm³)
     */
    private Integer volume;
    /**
     * 原价申报服务金额
     */
    private Integer originDeclareServiceAmount;

    /**
     * 申报服务金额
     */
    private Integer declareServiceAmount;
    /**
     * 原价申报服务金额
     */
    private Integer originReviewServiceAmount;

    /**
     * 复核服务金额
     */
    private Integer reviewServiceAmount;

    /**
     * 运输服务(1:进馆,2:出馆,3:进出馆)
     */
    private Integer transport;

    /**
     * 原价运输金额
     */
    private Integer originTransportAmount;

    /**
     * 运输金额(单位：分)
     */
    private Integer transportAmount;

    /**
     * 原价包装存储金额
     */
    private Integer originPackageAmount;

    /**
     * 包装存储金额(单位：分)
     */
    private Integer packageAmount;

    /**
     * 原价超限金额(单位：分)
     */
    private Integer originOverrunAmount;

    /**
     * 超限金额(单位：分)
     */
    private Integer overrunAmount;

    /**
     * 原价超重金额
     */
    private Integer originOverweightAmount;

    /**
     * 超重金额(单位：分)
     */
    private Integer overweightAmount;

    /**
     * 原价空箱搬运金额(单位：分)
     */
    private Integer originEmptyContainerAmount;
    /**
     * 空箱搬运金额(单位：分)
     */
    private Integer emptyContainerAmount;

    /**
     * 主办优惠金额
     */
    private Integer discountAmount;

    /**
     * 申报总额(单位：分)
     */
    private Integer totalAmount;

    /**
     * 实际金额(单位：分)
     */
    private Integer actualAmount;

    /**
     * 展品重量(单位:公斤)
     */
    private Integer weight;
    /**
     * 申报折扣
     */
    private List<ShipmentDeclareDiscount> declareDiscounts;
    /**
     * 复核折扣
     */
    private List<ShipmentDiscountVO> reviewDiscounts;

    /**
     * 申报折扣id
     */
    private List<Integer> declareDiscountIds;
    /**
     * 复核展品id
     */
    private List<Integer> reviewExhibitIds;
    /**
     * 复核服务id
     */
    private List<Integer> reviewServiceIds;
    /**
     * 复核折扣id
     */
    private List<Integer> reviewDiscountIds;
    /**
     * 复核展品列表
     */
    private List<ShipmentReviewExhibit> reviewExhibits;
    /**
     * 申报展品列表
     */
    private List<ShipmentDeclareExhibit> declareExhibits;

    /**
     * 申报服务列表
     */
    private List<ShipmentDeclareService> declareServices;
}
