package com.simm.exhibitor.bean.exhibitors;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
* Created by Mybatis Generator on 2020/07/08 13:51
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebPassTicket extends BaseBean {
    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("合同公司名")
    private String agreementName;

    @ApiModelProperty("公司名称")
    private String businessName;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("电话")
    private String phone;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("身份证号码")
    private String identityCard;

    @ApiModelProperty("职位")
    private String position;

    @ApiModelProperty("部门")
    private String department;

    @ApiModelProperty("展商证编号")
    private String uniqueNo;

    @ApiModelProperty("来源类型（1：预申领，2：现场申领）")
    private Integer sourceType;

    @ApiModelProperty("0免费1收费")
    private Integer isCharge;

    @ApiModelProperty("制证状态（0：否，1：是）")
    private Integer isAccredita;

    @ApiModelProperty("领取状态（0：否，1：是）")
    private Integer isReceive;

    @ApiModelProperty("")
    private Integer status;

    @ApiModelProperty("")
    private Integer createById;

    @ApiModelProperty("")
    private String createBy;

    @ApiModelProperty("")
    private Date createTime;

    @ApiModelProperty("")
    private String lastUpdateBy;

    @ApiModelProperty("")
    private Date lastUpdateTime;

    @ApiModelProperty("")
    private String remark;

    @ApiModelProperty("")
    private Integer isAbroad;

    //冗余字段
    private String boothId;

    @ApiModelProperty("")
    private String isAbroadExcel;

    @ApiModelProperty("")
    private Integer countryId;

    @ApiModelProperty("")
    private String countryName;

    @ApiModelProperty("")
    private Integer provinceId;

    @ApiModelProperty("")
    private String provinceName;

    @ApiModelProperty("")
    private Integer cityId;

    @ApiModelProperty("")
    private String cityName;

    @ApiModelProperty("")
    private Integer areaId;

    @ApiModelProperty("")
    private String areaName;

    private String address;

    /**
     * 昆仑票证id
     */
    private Long ticketId;
}