package com.simm.exhibitor.export;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.exhibits.SmebExhibitApplicationIndustry;
import com.simm.exhibitor.dto.exhibitor.ExhibitApplicationIndustryDTO;
import com.simm.exhibitor.vo.exhibits.ExhibitApplicationIndustryVO;

import java.util.List;

/**
 * @author liutao
 * @since 2022/12/14
 * 
 */
public interface ExhibitApplicationIndustryExport {


    /**
     * 展商行业分页查询
     * @param exhibitApplicationIndustryDTO 查询条件
     * @return 展商行业分页对象
     */
    PageInfo<ExhibitApplicationIndustryVO> page(ExhibitApplicationIndustryDTO exhibitApplicationIndustryDTO);

    /**
     * 更新
     * @param exhibitApplicationIndustryDTO 展商行业对象
     * @return true or false
     */
    boolean update(ExhibitApplicationIndustryDTO exhibitApplicationIndustryDTO);

    /**
     * 保存
     * @param exhibitApplicationIndustryDTO 展商行业对象
     * @return true or false
     */
    boolean save(ExhibitApplicationIndustryDTO exhibitApplicationIndustryDTO);

    /**
     * 根据Id查询
     * @param id id
     * @return 展商行业对象
     */
    ExhibitApplicationIndustryVO findById(Integer id);

    /**
     * 查询所有展商行业记录
     * @param exhibitApplicationIndustry {@link SmebExhibitApplicationIndustry}
     * @return {@link ExhibitApplicationIndustryVO}
     */
    List<ExhibitApplicationIndustryVO> list(SmebExhibitApplicationIndustry exhibitApplicationIndustry);

    /**
     * 删除二级分类
     * @param id id
     */
    void deleteExhibitCategory(Integer id);
}
