package com.simm.exhibitor.vo.reservation;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 *  ServiceOrderVO
 * @author chenyong
 * @since 2019/1/15 11:33
 **/
public class ServiceOrderVO extends BaseVO{

    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("订单来源")
    private String source;

    @ApiModelProperty("合同编号")
    private String agreementNo;

    @ApiModelProperty("合同url")
    private String agreementUrl;

    @ApiModelProperty("回传合同url")
    private String agreementUrlCallback;

    @ApiModelProperty("订单内容（json）")
    private String orderContent;

    @ApiModelProperty("总价（分）")
    private Integer totalPrice;

    @ApiModelProperty("已付金额(单位:分)")
    private Integer paidAmount;

    @ApiModelProperty("未付金额(单位:分)")
    private Integer unpaidAmount;

    @ApiModelProperty("已开票金额(单位:分)")
    private Integer openInvoiceAmount;

    @ApiModelProperty("订单状态")
    private Integer orderStatus;

    @ApiModelProperty("开票申请(1:未申请,2:新申请,3:已申请)")
    private Integer invoiceApply;

    @ApiModelProperty("搭建商公司名")
    private String exhibitorProduceCompany;

    @ApiModelProperty("搭建商联系人")
    private String exhibitorProduceName;

    @ApiModelProperty("搭建商手机联系人号码")
    private String exhibitorProduceMobile;

    @ApiModelProperty("合同公司名")
    private String agreementExhibitName;

    @ApiModelProperty("业务状态(1:未付款,2:已付部分,3:订单完成)")
    private Integer serviceStatus;

    @ApiModelProperty("附件url")
    private String attachmentUrl;

    @ApiModelProperty("是否担保（0：否，1：是））")
    private Integer isGuarantee;

    @ApiModelProperty("电子签名url")
    private String signatureUrl;

    @ApiModelProperty("导出批次")
    private String batchNo;

    @ApiModelProperty("发票公司名称")
    private String invoiceBusinessName;

    @ApiModelProperty("税号")
    private String taxNo;

    @ApiModelProperty("状态")
    private Integer status;

    @ApiModelProperty("订单商品详情")
    private List<ServiceOrderDetailVO> detailVOs;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<ServiceOrderDetailVO> getDetailVOs() {
        return detailVOs;
    }

    public void setDetailVOs(List<ServiceOrderDetailVO> detailVOs) {
        this.detailVOs = detailVOs;
    }

    public String getInvoiceBusinessName() {
        return invoiceBusinessName;
    }

    public void setInvoiceBusinessName(String invoiceBusinessName) {
        this.invoiceBusinessName = invoiceBusinessName;
    }

    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getSignatureUrl() {
        return signatureUrl;
    }

    public void setSignatureUrl(String signatureUrl) {
        this.signatureUrl = signatureUrl;
    }

    public Integer getIsGuarantee() {
        return isGuarantee;
    }

    public void setIsGuarantee(Integer isGuarantee) {
        this.isGuarantee = isGuarantee;
    }

    public String getAttachmentUrl() {
        return attachmentUrl;
    }

    public void setAttachmentUrl(String attachmentUrl) {
        this.attachmentUrl = attachmentUrl;
    }

    public String getAgreementExhibitName() {
        return agreementExhibitName;
    }

    public void setAgreementExhibitName(String agreementExhibitName) {
        this.agreementExhibitName = agreementExhibitName;
    }

    public Integer getServiceStatus() {

        return serviceStatus;
    }

    public void setServiceStatus(Integer serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getExhibitorUniqueId() {
        return exhibitorUniqueId;
    }

    public void setExhibitorUniqueId(String exhibitorUniqueId) {
        this.exhibitorUniqueId = exhibitorUniqueId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getAgreementNo() {
        return agreementNo;
    }

    public void setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
    }

    public String getAgreementUrl() {
        return agreementUrl;
    }

    public void setAgreementUrl(String agreementUrl) {
        this.agreementUrl = agreementUrl;
    }

    public String getAgreementUrlCallback() {
        return agreementUrlCallback;
    }

    public void setAgreementUrlCallback(String agreementUrlCallback) {
        this.agreementUrlCallback = agreementUrlCallback;
    }

    public String getOrderContent() {
        return orderContent;
    }

    public void setOrderContent(String orderContent) {
        this.orderContent = orderContent;
    }

    public Integer getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Integer totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Integer getPaidAmount() {
        return paidAmount;
    }

    public void setPaidAmount(Integer paidAmount) {
        this.paidAmount = paidAmount;
    }

    public Integer getUnpaidAmount() {
        return unpaidAmount;
    }

    public void setUnpaidAmount(Integer unpaidAmount) {
        this.unpaidAmount = unpaidAmount;
    }

    public Integer getOpenInvoiceAmount() {
        return openInvoiceAmount;
    }

    public void setOpenInvoiceAmount(Integer openInvoiceAmount) {
        this.openInvoiceAmount = openInvoiceAmount;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getInvoiceApply() {
        return invoiceApply;
    }

    public void setInvoiceApply(Integer invoiceApply) {
        this.invoiceApply = invoiceApply;
    }

    public String getExhibitorProduceCompany() {
        return exhibitorProduceCompany;
    }

    public void setExhibitorProduceCompany(String exhibitorProduceCompany) {
        this.exhibitorProduceCompany = exhibitorProduceCompany;
    }

    public String getExhibitorProduceName() {
        return exhibitorProduceName;
    }

    public void setExhibitorProduceName(String exhibitorProduceName) {
        this.exhibitorProduceName = exhibitorProduceName;
    }

    public String getExhibitorProduceMobile() {
        return exhibitorProduceMobile;
    }

    public void setExhibitorProduceMobile(String exhibitorProduceMobile) {
        this.exhibitorProduceMobile = exhibitorProduceMobile;
    }

    public String getBoothNo() {
        return boothNo;
    }

    public void setBoothNo(String boothNo) {
        this.boothNo = boothNo;
    }
}
