package com.simm.exhibitor.vo.shipment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.simm.exhibitor.bean.shipment.ShipmentDeclareDiscount;
import com.simm.exhibitor.bean.shipment.ShipmentDeclareExhibit;
import com.simm.exhibitor.bean.shipment.ShipmentDeclareService;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author liutao
 * @since 2024/8/6
 */
@Data
public class ShipmentDeclareVO implements Serializable {

    /**
     * id
     */
    private Integer id;

    /**
     * 展商id
     */
    private String uniqueId;

    /**
     * 公司名
     */
    private String businessName;

    /**
     * 展馆id
     */
    private String boothId;

    /**
     * 展位号
     */
    private String boothNo;

    /**
     * 联系人
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactMobile;

    /**
     * 作业时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date workDate;

    /**
     * 车牌
     */
    private String carNo;

    /**
     * 原价申报服务金额
     */
    private Integer originDeclareServiceAmount;

    /**
     * 申报服务金额
     */
    private Integer declareServiceAmount;

    /**
     * 原价进出馆金额
     */
    private Integer originTransportAmount;

    /**
     * 进出馆金额
     */
    private Integer transportAmount;

    /**
     * 原价空箱存储金额
     */
    private Integer originPackageAmount;

    /**
     * 空箱存储金额
     */
    private Integer packageAmount;
    /**
     * 原价超限金额(单位：分)
     */
    private Integer originOverrunAmount;

    /**
     * 超限金额(单位：分)
     */
    private Integer overrunAmount;

    /**
     * 原价超重金额
     */
    private Integer originOverweightAmount;

    /**
     * 超重金额(单位：分)
     */
    private Integer overweightAmount;

    /**
     * 原价空箱搬运金额(单位：分)
     */
    private Integer originEmptyContainerAmount;
    /**
     * 空箱搬运金额(单位：分)
     */
    private Integer emptyContainerAmount;

    /**
     * 主办优惠金额
     */
    private Integer discountAmount;

    /**
     * 申报总额(单位：分)
     */
    private Integer totalAmount;

    /**
     * 实际金额(单位：分)
     */
    private Integer actualAmount;

    /**
     * 申报单url
     */
    private String declarationUrl;

    /**
     * 申报时间
     */
    private Date declarationTime;

    /**
     * 回签申报单url
     */
    private String declarationSignUrl;

    /**
     * 回签申报单时间
     */
    private Date declarationSignTime;

    /**
     * 是否锁定
     */
    private Boolean declarationLock;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 最后更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date lastUpdateTime;

    /**
     * 申报展品
     */
    private List<ShipmentDeclareExhibit> exhibits;
    /**
     * 申报服务
     */
    private List<ShipmentDeclareService> services;
    /**
     * 申报折扣
     */
    private List<ShipmentDeclareDiscount> discounts;
}
