package com.simm.exhibitor.bean.shipment;

import com.simm.common.bean.BaseBean;
import java.math.BigDecimal;
import java.util.Date;

import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
* Created by Mybatis Generator on 2024/07/29 09:53
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShipmentDeclareService extends BaseBean {


    /**
     * id
     */
    private Integer id;

    /**
     * 展商id
     */
    private String uniqueId;

    /**
     * 服务类型
     */
    @NotBlank(message = "服务类型不能为空")
    private String type;

    /**
     * 服务名称
     */
    @NotBlank(message = "服务名称不能为空")
    private String name;

    /**
     * 单价
     */
    @NotNull(message = "单价不能为空")
    private Integer price;

    /**
     * 单位
     */
    private String unit;

    /**
     * 原价总金额
     */
    private Integer originTotalAmount;

    /**
     * 实际总金额
     */
    private Integer totalAmount;

    /**
     * 数量
     */
    @NotNull(message = "数量不能为空")
    private BigDecimal quantity;
    /**
     * 使用数量
     */
    private BigDecimal useQuantity;
    /**
     * 0 未复核 1 未复核
     */
    private Boolean review;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后更新时间
     */
    private Date lastUpdateTime;
}