package com.simm.exhibitor.dubbo.shipment;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.shipment.ShipmentOrder;
import com.simm.exhibitor.dto.shipment.ShipmentOrderDTO;
import com.simm.exhibitor.vo.shipment.ShipmentExhibitorVO;
import com.simm.exhibitor.vo.shipment.ShipmentOrderDetailVO;
import com.simm.exhibitor.vo.shipment.ShipmentOrderVO;
import com.simm.exhibitor.vo.shipment.ShipmentStatisticAmountVO;

import java.util.List;

/**
 * @author liutao
 * @since 2024/8/5
 */
public interface ShipmentOrderDubboService {

    /**
     * 查询承运订单列表
     * @param shipmentOrderDTO {@link ShipmentOrderDTO}
     * @return {@link ShipmentOrderVO}
     */
    PageInfo<ShipmentOrderVO> findPage(ShipmentOrderDTO shipmentOrderDTO);

    /**
     * 查询承运展商列表
     * @param shipmentOrderDTO {@link ShipmentOrderDTO}
     * @return {@link ShipmentExhibitorVO}
     */
    PageInfo<ShipmentExhibitorVO> findShipmentExhibitorPage(ShipmentOrderDTO shipmentOrderDTO);

    /**
     * 查询承运统计金额
     * @param shipmentOrderDTO {@link ShipmentOrderDTO}
     * @return {@link ShipmentStatisticAmountVO}
     */
    ShipmentStatisticAmountVO findShipmentStatisticAmount(ShipmentOrderDTO shipmentOrderDTO);

    /**
     * 订单详情
     * @param id 订单id
     * @return {@link ShipmentOrderDetailVO}
     */
    ShipmentOrderDetailVO findDetailById(Integer id);

    /**
     * 退单
     * @param id 订单id
     */
    void cancel(Integer id);
    /**
     * 创建订单
     * @param shipmentOrderDTO {@link ShipmentOrderDTO}
     * @return {@link ShipmentOrderDetailVO}
     */
    ShipmentOrderDetailVO createOrder(ShipmentOrderDTO shipmentOrderDTO);
    /**
     * 查询已付款的订单
     * @param boothNo 展位号
     * @param year 年份
     * @return {@link ShipmentOrder}
     */
    List<ShipmentOrder> findPaidOrder(String boothNo, Integer year);

    /**
     * 根据id查询订单
     * @param ids ids
     * @return {@link ShipmentOrder}
     */
    List<ShipmentOrder> findByIds(List<Integer> ids);

    /**
     * 批量更新
     * @param shipmentOrders {@link ShipmentOrder}
     */
    void batchUpdate(List<ShipmentOrder> shipmentOrders);

    /**
     * 更新打印状态
     * @param id id
     * @param printStatus 打印状态 0 未打印 1 已打印
     */
    void updatePrintStatus(Integer id, Integer printStatus);

    /**
     * 添加追加优惠金额
     * @param id id
     * @param appendDiscountAmount 追加优惠金额
     */
    void addAppendDiscountAmount(Integer id, Integer appendDiscountAmount);
}
