package com.simm.exhibitor.vo.shipment;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liutao
 * @since 2023/9/11
 */
@Data
@ColumnWidth(30)
public class ShipmentServiceExcelVO implements Serializable {

    @ExcelProperty("公司名称")
    private String businessName;

    @ExcelProperty("展位号")
    private String boothNo;

    @ExcelProperty("服务单号")
    private String orderNo;

    @ExcelProperty("服务名称")
    private String name;

    @ExcelProperty("单价(元)")
    private BigDecimal price;

    @ExcelProperty("数量")
    private BigDecimal quantity;

    @ExcelProperty("金额(元)")
    private BigDecimal totalAmount;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty("申报时间")
    private String declarationTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty("作业时间")
    private String workDate;
}
