package com.simm.exhibitor.dto.exhibitor;

import com.simm.exhibitor.bean.exhibitors.SmebExhibitorInfoExhibit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author Yingjianghua
 * @version v1.0
 *  ExhibitorInfoDto
 * 
 * @since 2019/1/18 14:10
 */
@Data
@ApiModel("展商展品DTO")
public class ExhibitorInfoExhibitorDto implements Serializable {


    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("展商id")
    private Integer exhibitorInfoId;

    @ApiModelProperty("展品名")
    private String name;

    @ApiModelProperty("展品英文名")
    private String nameEn;

    @ApiModelProperty("展品介绍")
    private String introduce;

    @ApiModelProperty("展品英文介绍")
    private String introduceEn;

    @ApiModelProperty("展品url")
    private String imgUrl;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新人")
    private String lastUpdateBy;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("备注")
    private String remark;

    private String appid;

    @ApiModelProperty("展品类型，0：无类型，1：热销类型，2：主打产品，3：口碑产品")
    private Integer type;

    private Integer exhibitCategoryId;

    private List<Integer> exhibitCategoryIds;

    private Integer pageNum;

    private Integer pageSize;

    private String searchKey;

    private Integer year;

    @ApiModelProperty("展商展品")
    private List<SmebExhibitorInfoExhibit> exhibitorInfoExhibitDtos;

}
