package com.simm.exhibitor.bean.bulid;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
* Created by Mybatis Generator on 2019/10/15 14:36
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebExhibitionBuild extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("参展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("参展商名称")
    private String exhibitor;

    @ApiModelProperty("展馆号")
    private String boothId;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系人手机号码")
    private String contactMobile;

    @ApiModelProperty("联系人座机号码")
    private String contactPhone;

    @ApiModelProperty("联系人邮箱")
    private String contactEmail;

    @ApiModelProperty("楣板类型(1:统一楣板,2:自定义楣板)")
    private Integer template;

    @ApiModelProperty("公司名称（中文）")
    private String companyName;

    @ApiModelProperty("公司名称（英文）")
    private String companyEname;

    @ApiModelProperty("标准展位配置")
    private String standardBooth;

    @ApiModelProperty("标准配置数量")
    private Integer standardQuantity;

    @ApiModelProperty("自定义展位配置")
    private CustomStandardBooth customStandardBooth;

    @ApiModelProperty("文件路径")
    private String fileUrl;

    @ApiModelProperty("申请铺地毯时间")
    private String decTime;

    @ApiModelProperty("是否需要间隔板说明")
    private String clapboardDesc;

    @ApiModelProperty("特殊要求说明")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    //冗余字段

    private List<String> exhibitorUniqueIds;

    private Integer exhibitorBaseinfoId;

}