package com.simm.exhibitor.vo.basic;

import com.simm.common.utils.DateUtil;
import com.simm.common.vo.BaseVO;
import com.simm.exhibitor.vo.exhibitors.ExhibitorInfoExhibitVO;
import com.simm.exhibitor.vo.exhibitors.SmebSiteActivityVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 *  ExhibitorInfoVO
 * @author chenyong
 * @since 2018/12/26 14:29
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ExhibitorInfoVO extends BaseVO {

    private Integer id;

    @ApiModelProperty("展商id")
    private Integer exhibitorBaseinfoId;

    @ApiModelProperty("用户名")
    private String username;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("编号")
    private String uniqueId;

    @ApiModelProperty("父id")
    private Integer pid;

    @ApiModelProperty("公司名")
    private String businessName;

    @ApiModelProperty("公司名简称")
    private String businessNameShort;

    @ApiModelProperty("公司英文名称")
    private String businessNameEn;

    @ApiModelProperty("公司称号")
    private String businessTitle;

    @ApiModelProperty("股票代码")
    private String stockCode;

    @ApiModelProperty("上市状态")
    private Integer listedStatus;

    @ApiModelProperty("logo地址")
    private String logoUrl;

    @ApiModelProperty("合同编号")
    private Long agreementNo;

    @ApiModelProperty("合同类型")
    private String agreementType;

    @ApiModelProperty("合同显示的展览类型")
    private String agreementExhibitType;

    @ApiModelProperty("展馆")
    private String boothId;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("展位面积")
    private Double boothArea;

    @ApiModelProperty("展位类型")
    private Integer boothType;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系人手机")
    private String contactMobile;

    @ApiModelProperty("联系人邮箱")
    private String contactEmail;

    @ApiModelProperty("第二联系人")
    private String secondContactName;

    @ApiModelProperty("第二联系人手机号码")
    private String secondContactMobile;

    @ApiModelProperty("第二联系人邮箱")
    private String secondContactEmail;

    @ApiModelProperty("会刊公司名")
    private String comBusinessName;

    @ApiModelProperty("会刊英文公司名")
    private String comBusinessNameEn;

    @ApiModelProperty("会刊公司座机")
    private String comBusinessTelphone;

    @ApiModelProperty("会刊公司地址")
    private String comBusinessAddress;

    @ApiModelProperty("会刊公司英文地址")
    private String comBusinessAddressEn;

    @ApiModelProperty("会刊公司网址")
    private String comBusinessWebsite;

    @ApiModelProperty("会刊公司传真")
    private String comBusinessFax;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("品牌名称-英文")
    private String brandNameEn;

    @ApiModelProperty("公司简介")
    private String introduce;

    @ApiModelProperty("公司简介（英文）")
    private String introduceEn;

    @ApiModelProperty("展品类别")
    private String exhibitsCategory;

    @ApiModelProperty("知名品牌（0：否，1：是）")
    private Integer isBrands;

    @ApiModelProperty("人气企业")
    private Integer isPopularBusiness;

    @ApiModelProperty("优势")
    private String advantage;

    @ApiModelProperty("应用行业")
    private String applicationIndustry;

    @ApiModelProperty("应用行业（英文）")
    private String applicationIndustryEn;

    @ApiModelProperty("展区分类")
    private String exhibitionAreaClassify;

    @ApiModelProperty("主营产品")
    private String mainProduct;

    @ApiModelProperty("主营产品（英文）")
    private String mainProductEn;

    @ApiModelProperty("")
    private Integer countryId;

    @ApiModelProperty("")
    private String countryName;

    @ApiModelProperty("")
    private Integer provinceId;

    @ApiModelProperty("")
    private String provinceName;

    @ApiModelProperty("")
    private Integer cityId;

    @ApiModelProperty("")
    private String cityName;

    @ApiModelProperty("")
    private Integer areaId;

    @ApiModelProperty("")
    private String areaName;

    @ApiModelProperty("校验方式（1：手机，2：邮箱）")
    private Integer checkWay;

    @ApiModelProperty("是否开通")
    private Integer enable;

    @ApiModelProperty("审批状态-1-未审批 0-初始化状态 1-审批通过 2-审批拒绝")
    private Integer approveStatus;

    @ApiModelProperty("审批备注")
    private String approveRemark;

    @ApiModelProperty("展品类别")
    private List<String> exhibitsCategorys;

    @ApiModelProperty("应用行业")
    private List<String> applicationIndustrys;

    @ApiModelProperty("系统当前时间")
    private String sysCurrentTime = DateUtil.toDate(new Date());

    @ApiModelProperty("邀请观众人数")
    private Integer count;

    @ApiModelProperty("排名")
    private Integer rankingNo;

    @ApiModelProperty("邀请函id")
    private Integer invitationId;

    @ApiModelProperty("邀请函公司名")
    private String invitationName;

    @ApiModelProperty("小程序码图片地址")
    private String mpcodeUrl;

    @ApiModelProperty("展品信息")
    private List<ExhibitorInfoExhibitVO> exhibitList;

    @ApiModelProperty("路线图片地址")
    private String routeImgUrl;

    @ApiModelProperty("图标")
    private Integer icon;

    @ApiModelProperty("展商邀请数量")
    private Integer exhibitorInviteCount;

    @ApiModelProperty("收款账户")
    private String receiptBankAccount;

    @ApiModelProperty("收款账户 英文")
    private String receiptBankAccountEn;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("现场活动信息")
    private List<SmebSiteActivityVO> siteActivityList;

    private String draft;

    private List<String> brandNames;

    private List<String> brandNameEns;

    private List<SmebSiteActivityVO> siteActivityDTOList;
    /**
     * 展品图片合成视频url
     */
    private String synthesisVideoUrl;

    private String exhibitName;

    /**
     * 销售合同金额
     */
    private Integer saleContractAmount;
}
