package com.simm.hive.dubbo.basic.dto;

import lombok.Data;

import java.io.Serializable;


/**
 * @author liutao
 * @since 2023/12/7
 */
@Data
public class PreRegisterSourceDTO implements Serializable {

    private Integer id;

    /**
     * 来源类型
     */
    private Integer typeId;

    /**
     * 类型名
     */
    private String typeName;

    /**
     * 预登记来源key
     */
    private String sourceKey;

    /**
     * 预登记来源名称
     */
    private String sourceName;

    /**
     * 旧链接
     */
    private String oldUrl;

    /**
     * 转换后新链接
     */
    private String newUrl;

    /**
     * 语言类型（1：cn，2：en）
     */
    private Integer languageType;

    /**
     * 届数
     */
    private Integer number;
    /**
     * 备注
     */
    private String remark;

    /**
     * 旧官网（1）还是新官网（2）
     */
    private Integer websiteSource;
}
