package com.simm.hive.dubbo.basic.service;

import com.simm.hive.dubbo.basic.dto.PreRegisterSourceDTO;

import java.util.List;

/**
 * @author liutao
 * @since 2023/12/7
 */
public interface PreRegisterSourceDubboService {

    /**
     * 保存预登记来源
     * @param preRegisterSourceDTO {@link PreRegisterSourceDTO}
     */
    void save(PreRegisterSourceDTO preRegisterSourceDTO);

    /**
     * 根据来源key查询预登记来源
     * @param sourceKeys 来源key
     * @param typeId 类型id
     * @return {@link PreRegisterSourceDTO}
     */
    List<PreRegisterSourceDTO> findBySourceKeysAndTypeId(List<String> sourceKeys, Integer typeId);

    /**
     * 根据来源名称查询预登记来源
     * @param sourceName 来源名称
     * @return {@link PreRegisterSourceDTO}
     */
    List<PreRegisterSourceDTO> findList(String sourceName, Integer typeId);
}
