package com.simm.hive.dubbo.team.service;

import com.simm.hive.dubbo.team.dto.TeamBusinessDTO;
import com.simm.hive.dubbo.team.dto.TeamBusinessPageDTO;

import java.util.List;

/**
 * @author liutao
 * @since 2024/3/11
 */
public interface TeamBusinessDubboService {


    /**
     * 查询参观团列表
     * @param teamBusinessDTO 查询条件
     * @return {@link TeamBusinessDTO}
     */
    List<TeamBusinessDTO> list(TeamBusinessDTO teamBusinessDTO);

    /**
     * 查询参观团列表
     * @param teamBusinessDTO 查询条件
     * @return {@link TeamBusinessPageDTO}
     */
    TeamBusinessPageDTO page(TeamBusinessDTO teamBusinessDTO);

    /**
     * 领取车票
     * @param teamBusinessId 参观团id
     * @param drawNum 领取数量
     */
    void draw(Integer teamBusinessId, Integer drawNum);

    /**
     * 根据参观团id查询对应的巴士信息
     * @param teamBusinessId 参观团id
     * @return {@link TeamBusinessDTO}
     */
    TeamBusinessDTO getBusDetailListByTeamBusinessId(Integer teamBusinessId);
}
