package com.simm.hive.dubbo.visit.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author liutao
 * @since 2023/11/17
 */
@ToString
@Data
public class VisitRegisterDTO implements Serializable {

    /**
     * 主键id
     */
    private Integer id;

    /**
     * 代报名的预登记id
     */
    private Integer agentRegisterId;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 届数
     */
    private Integer numbers;

    /**
     * 证件编号
     */
    private String cardNo;

    /**
     * 姓名
     */
    private String name;


    /**
     * 公司名
     */
    private String company;

    /**
     * 部门
     */
    private String department;

    /**
     * 职务
     */
    private String position;

    /**
     * 手机
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;


    /**
     * 问卷
     */
    private List<Object> question;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 国家id
     */
    private Integer countryId;

    /**
     * 国家
     */
    private String country;

    /**
     * 省份id
     */
    private Integer provinceId;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市id
     */
    private Integer cityId;

    /**
     * 城市
     */
    private String city;

    /**
     * 区域id
     */
    private Integer areaId;

    /**
     * 区域
     */
    private String area;


    /**
     * 供应商同步状态(0:未同步,1:已同步)
     */
    private Boolean supplierSync;


    /**
     * 短信发送状态
     */
    private String smsStatus;

    /**
     * 来源
     */
    private String source;


    /**
     * 预登记链接
     */
    private String preRegistUrl;

    /**
     * 展商扩邀编码
     */
    private String exhibitorInviteNo;

    /**
     * 展商业务员姓名
     */
    private String exhibitorInviteUser;

    /**
     * 展商扩邀来源
     */
    private String exhibitionSource;


    /**
     * 名片url
     */
    private String businessCardUrl;


    /**
     * 邀请人唯一Id
     */
    private Integer inviteUserId;

    /**
     * 证件类型（1：身份证，2：军官证，3：护照，4：港澳台居住证/通行证）
     */
    private Integer identityCardType;

    /**
     * 身份证号
     */
    private String identityCard;

    /**
     * 兑换码
     **/
    private String redeemCode;

    /**
     * 订单编号
     **/
    private String orderSn;

    /**
     * 订单状态
     **/
    private Integer orderStatus;

    /**
     * 备注
     */
    private String remark;
    /**
     * level
     */
    private Integer level;

    /**
     * 微信unionId
     */
    private String unionId;

    /**
     * 性别
     */
    private Integer sex;
    /**
     * 到场状态
     */
    private Integer sitStatus;
    /**
     * 所属行业
     */
    private String industry;
    /**
     * 邀请人数
     */
    private String inviteCount;
    /**
     * 是否多人
     */
    private Integer hasMultiple;
    /**
     * 来源分类id
     */
    private Integer preRegisterSourceTypeId;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;
    /**
     * 是否团体登记信息
     */
    private Boolean isGroupRegister;
    /**
     * 昆仑一发票据id
     */
    private Long ticketId;
}
