package com.simm.hive.dubbo.visit.service;

import com.github.pagehelper.PageInfo;
import com.simm.hive.dubbo.visit.dto.VisitRegisterDTO;

import java.util.List;

/**
 * @author liutao
 * @since 2023/11/16
 */
public interface VisitRegisterDubboService {

    /**
     * 保存登记信息
     * @param visitRegisterDTO {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     * @return id
     */
    Integer saveRegisterInfo(VisitRegisterDTO visitRegisterDTO);

    /**
     * 根据手机查询团体登记信息，并新增到个人登记信息里面
     * @param visitRegisterDTO {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO saveRegisterInfoByTeamBusinessStaffInfo(VisitRegisterDTO visitRegisterDTO);
    /**
     * 更新登记信息短信发送状态
     * @param smsStatus 短信发送状态
     * @param id 登记id
     */
    void updateSmsStatueById(String smsStatus, Integer id);

    /**
     * 根据用户ID查询登记信息
     * @param userId 用户ID
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findByUserId(Integer userId);

    /**
     * 根据手机号查询登记信息
     * @param mobile 手机号
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findByMobile(String mobile);

    /**
     * 根据手机号查询登记信息
     * @param mobiles 手机号
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    List<VisitRegisterDTO> findByMobiles(List<String> mobiles);

    /**
     * 根据手机号和用户ID查询登记信息
     * @param mobile 手机号
     * @param webUserId 登记用户id
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findUserRegisterInfo(String mobile,Integer webUserId);

    /**
     * 根据手机号查询上届登记信息
     * @param mobile 手机号
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findLastRegisterInfoByMobile(String mobile);

    /**
     * 根据id查询登记信息
     * @param id id
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findById(Integer id);

    /**
     * 通过证件号查询登记信息
     * @param cardNo 证件号
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findByCardNo(String cardNo);

    /**
     * 根据订单编号查询登记信息
     * @param orderSn 订单编号
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findByOrderSn(String orderSn);

    /**
     * 添加同行人
     * @param list {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    void batchAddPartner(List<VisitRegisterDTO> list);

    /**
     * 根据代登记id查询同行人
     * @param agentRegisterId 代登记id
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    List<VisitRegisterDTO> findByAgentRegisterId(Integer agentRegisterId);

    /**
     * 根据代登记用户id查询同行人
     * @param inviteUserId 代登记用户id
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    List<VisitRegisterDTO> findByInviteUserId(Integer inviteUserId);

    /**
     * 根据身份证号查询登记信息
     * @param identityCard 身份证号
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    VisitRegisterDTO findByIdentityCard(String identityCard);

    /**
     * 根据来源查询邀请人数
     * @param source 来源
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    List<VisitRegisterDTO> findInviteCountBySource(String source);

    /**
     * 根据供应商同步查询登记信息
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    List<VisitRegisterDTO> findBySupplierSync();

    /**
     * 更新供应商同步状态
     * @param cardNos 证件号
     */
    void updateSupplierSyncByCardNos(List<String> cardNos);

    /**
     * 根据来源和邀请编号查询邀请数量
     * @param source 来源
     * @param exhibitorInviteNo 邀请编号
     * @return 邀请数量
     */
    Integer countBySourceAndExhibitorInviteNo(String source, String exhibitorInviteNo);

    /**
     * 根据来源和邀请编号查询记录
     * @param source 来源
     * @param exhibitorInviteNo 邀请编号
     * @param searchKey 搜索关键字
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}
     */
    List<VisitRegisterDTO> findBySourceAndExhibitorInviteNo(String source, String exhibitorInviteNo, String searchKey);

    /**
     * 分页查询登记信息
     * @param pageNum 页码
     * @param pageSize 每页数量
     * @param source 来源
     * @param exhibitorInviteNo 邀请编号
     * @param searchKey 搜索关键字
     * @return {@link com.simm.hive.dubbo.visit.dto.VisitRegisterDTO}}
     */
    PageInfo<VisitRegisterDTO> findByPage(Integer pageNum, Integer pageSize, String source, String exhibitorInviteNo, String searchKey);

    /**
     * 根据id删除登记信息
     * @param id id
     */
    void removeById(Integer id);

    /**
     * 根据id删除登记信息
     * @param ids id
     */
    void removeByIds(List<Integer> ids);

    /**
     * 根据手机号删除登记信息
     * @param mobiles 手机号
     */
    void removeByMobiles(List<String> mobiles);

    /**
     * 更新到场状态和到场时间
     * @param ticketId 昆仑一发票据id
     * @param cardNo 证件号
     * @param sitTime 到场时间
     */
    void updateSitStatusAndTime(Long ticketId, String cardNo, String sitTime);
}
