package com.simm.hive.dubbo.visit.service;

import com.simm.hive.dubbo.visit.dto.TeamBusinessDTO;
import com.simm.hive.dubbo.visit.dto.TeamBusinessStaffDTO;

import java.util.List;

/**
 * @author liutao
 * @since 2023/11/16
 */
public interface VisitRegisterGroupDubboService {


    /**
     * 保存参观团
     * @param teamBusinessDTO {@link TeamBusinessDTO}
     * @return 参观团id
     */
    Integer saveTeamBusiness(TeamBusinessDTO teamBusinessDTO);
    /**
     * 删除参观团
     * @param teamBusinessId 参观团id
     */
    void removeTeamBusiness(Integer teamBusinessId);

    /**
     * 根据名称查询参观团
     * @param name 名称
     * @return {@link TeamBusinessDTO}
     */
    TeamBusinessDTO findByName(String name);
    /**
     * 根据id查询参观团
     * @param teamBusinessId 参观团id
     * @return {@link TeamBusinessDTO}
     */
    TeamBusinessDTO getTeamBusinessById(Integer teamBusinessId);

    /**
     * 保存参观团成员
     * @param teamBusinessStaffDTO {@link TeamBusinessStaffDTO}
     * @return id
     */
    Integer saveTeamBusinessMember(TeamBusinessStaffDTO teamBusinessStaffDTO);

    /**
     * 根据手机号查询参观团成员
     * @param mobile 手机号
     * @return {@link TeamBusinessStaffDTO}
     */
    TeamBusinessStaffDTO getByMobile(String mobile);

    /**
     * 根据参观团id查询参观团成员
     * @param teamBusinessId 参观团id
     * @return {@link TeamBusinessStaffDTO}
     */
    List<TeamBusinessStaffDTO> getByTeamBusinessId(Integer teamBusinessId);

    /**
     * 更新参观团主联系人
     * @param teamBusinessStaffId 参观团成员id
     * @param teamBusinessId 参观团id
     */
    void updateMaster(Integer teamBusinessStaffId, Integer teamBusinessId);

    /**
     * 根据id查询参观团成员
     * @param id id
     * @return {@link TeamBusinessStaffDTO}
     */
    TeamBusinessStaffDTO getById(Integer id);

    /**
     * 根据id删除参观团成员
     * @param id id
     */
    void removeById(Integer id);

    /**
     * 更新到场状态和到场时间
     * @param ticketId 昆仑一发票据id
     * @param cardNo 证件号
     * @param sitTime 到场时间
     */
    void updateSitStatusAndTime(Long ticketId, String cardNo, String sitTime);
}
