package com.simm.hive.dubbo.wechat.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liutao
 * @since 2023/12/12
 */
@Data
public class WeContactWayDTO implements Serializable {

    /**
     * 主键
     */
    private Integer id;

    /**
     * 来源id，smdm_we_source.id
     */
    private Integer sourceId;

    /**
     * 联系方式名称
     */
    private String name;
    /**
     * 场景，1-在小程序中联系，2-通过二维码联系，默认为 2
     */
    private Integer scene;
    /**
     * 使用该联系方式的用户userID列表，在type为1时为必填，且只能有一个
     */
    private String[] user;
    /**
     * 新增联系方式的配置id
     */
    private String configId;
    /**
     * 联系我二维码链接，仅在scene为2时返回
     */
    private String qrCode;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 最后更新人
     */
    private String lastUpdateBy;
    /**
     * 最后更新时间
     */
    private Date lastUpdateTime;
    /**
     * 备注
     */
    private String remark;
}
