package com.simm.hive.dubbo.wechat.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liutao
 * @since 2023/12/12
 */
@Data
public class WeJoinWayDTO implements Serializable {

    /**
     * 主键
     */
    private Integer id;

    /**
     * 来源id，smdm_we_source.id
     */
    private Integer sourceId;

    /**
     * 进群方式名称
     */
    private String name;

    /**
     * 场景，1 - 群的小程序插件，2 - 群的二维码插件，默认为 2
     */
    private Integer scene;

    /**
     * 使用该配置的客户群ID列表，支持5个。
     */
    private String[] chatIdList;

    /**
     * 当群满了后，是否自动新建群。0-否；1-是。 默认为1
     */
    private Integer autoCreateRoom;

    /**
     * 自动建群的群名前缀，当auto_create_room为1时有效。最长40个utf8字符
     */
    private String roomBaseName;

    /**
     * 自动建群的群起始序号，当auto_create_room为1时有效
     */
    private Integer roomBaseId;
    /**
     * 新增联系方式的配置id
     */
    private String configId;
    /**
     * 联系我二维码链接，仅在scene为2时返回
     */
    private String qrCode;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 最后更新人
     */
    private String lastUpdateBy;
    /**
     * 最后更新时间
     */
    private Date lastUpdateTime;
}
