/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesUtil {
    protected static final Logger logger = LogManager.getLogger();
    private static Map<String, Object> map = new HashMap<String, Object>();

    public static String getPropertiesValue(String propFileName, String propertiesKey) {
        try {
            Properties properties = new Properties();
            if (null == map.get(propFileName)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStreamReader config = new InputStreamReader(cl.getResourceAsStream(propFileName), "UTF-8");
                properties.load(config);
                config.close();
                map.put(propFileName, properties);
                return properties.getProperty(propertiesKey);
            }
            properties = (Properties)map.get(propFileName);
            return properties.getProperty(propertiesKey);
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return null;
    }

    public static String getPropertiesChangeValue(String propFileName, String propertiesKey) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Properties properties = new Properties();
        try {
            InputStreamReader config = new InputStreamReader(cl.getResourceAsStream(propFileName), "UTF-8");
            properties.load(config);
            config.close();
            return properties.getProperty(propertiesKey);
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return null;
    }

    public static String getMessage(String propertiesKey) {
        return PropertiesUtil.getPropertiesValue("properties/message_code.properties", propertiesKey);
    }
}

