/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import com.sun.crypto.provider.SunJCE;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class DesUtil {
    private static String strDefaultKey = "SIMM_DES";
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public DesUtil() throws Exception {
        this(strDefaultKey);
    }

    private static String byteArr2HexStr(byte[] arrB) throws Exception {
        int iLen = arrB.length;
        StringBuffer sb = new StringBuffer(iLen * 2);
        for (int i = 0; i < iLen; ++i) {
            int intTmp;
            for (intTmp = arrB[i]; intTmp < 0; intTmp += 256) {
            }
            if (intTmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(intTmp, 16));
        }
        return sb.toString();
    }

    private static byte[] hexStr2ByteArr(String strIn) throws Exception {
        byte[] arrB = strIn.getBytes();
        int iLen = arrB.length;
        byte[] arrOut = new byte[iLen / 2];
        for (int i = 0; i < iLen; i += 2) {
            String strTmp = new String(arrB, i, 2);
            arrOut[i / 2] = (byte)Integer.parseInt(strTmp, 16);
        }
        return arrOut;
    }

    public DesUtil(String strKey) throws Exception {
        Security.addProvider(new SunJCE());
        Key key = this.getKey(strKey.getBytes());
        this.encryptCipher = Cipher.getInstance("DES");
        this.encryptCipher.init(1, key);
        this.decryptCipher = Cipher.getInstance("DES");
        this.decryptCipher.init(2, key);
    }

    public byte[] encrypt(byte[] arrB) throws Exception {
        return this.encryptCipher.doFinal(arrB);
    }

    public String encrypt(String strIn) throws Exception {
        return DesUtil.byteArr2HexStr(this.encrypt(strIn.getBytes()));
    }

    public byte[] decrypt(byte[] arrB) throws Exception {
        return this.decryptCipher.doFinal(arrB);
    }

    public String decrypt(String strIn) throws Exception {
        return new String(this.decrypt(DesUtil.hexStr2ByteArr(strIn)));
    }

    private Key getKey(byte[] arrBTmp) throws Exception {
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }

    public static void main(String[] args) {
        try {
            String test = "?aa=1";
            DesUtil des = new DesUtil();
            System.out.println("\u52a0\u5bc6\u524d\u7684\u5b57\u7b26\uff1a" + test);
            System.out.println("\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\uff1a" + des.encrypt(test).toUpperCase());
            System.out.println("\u89e3\u5bc6\u540e\u7684\u5b57\u7b26\uff1a" + des.decrypt(des.encrypt(test).toUpperCase()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

