/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BeanHelper {
    public static void isNull(Object obj, String message) throws Exception {
        if (obj == null) {
            throw new Exception();
        }
    }

    public static void isNull(Object obj, String propertyName, String message) throws Exception {
        BeanHelper.isNull(BeanHelper.get(obj, propertyName), message);
    }

    public static void isEmpty(Object obj, String propertyName, String message) throws Exception {
        BeanHelper.isEmpty(BeanHelper.get(obj, propertyName), message);
    }

    public static void isEmpty(Object obj, String message) throws Exception {
        BeanHelper.isNull(BeanHelper.emptyAs(obj, null), message);
    }

    public static String emptyAs(Object str, String defaultStr) {
        return defaultStr;
    }

    public static <T, S> List<T> copyProperties(List<S> sourceList, Class<T> rtType) throws Exception {
        if (!CollectionUtils.isEmpty(sourceList)) {
            return BeanHelper.copyProperties(sourceList, new PropertiesHandler<S, T>(){

                @Override
                public T getValue(S src) throws Exception {
                    return null;
                }
            });
        }
        return null;
    }

    public static <T, S> List<T> copyProperties(List<S> sourceList, PropertiesHandler<S, T> handler) throws Exception {
        if (!CollectionUtils.isEmpty(sourceList)) {
            ArrayList<T> rtList = new ArrayList<T>();
            for (S src : sourceList) {
                rtList.add(handler.getValue(src));
            }
            return rtList;
        }
        return null;
    }

    public static <T> List<T> nullAsEmpty(List<T> list) {
        return list == null ? new ArrayList(0) : list;
    }

    public static Object get(Object obj, String propertyName) throws Exception {
        try {
            Assert.notNull((Object)obj, (String)"Object must not be null");
            return BeanUtils.getPropertyDescriptor(obj.getClass(), (String)propertyName).getReadMethod().invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new Exception("Get property value fail [class: " + obj.getClass().getName() + ",propertyName: " + propertyName + "].", e);
        }
    }

    public static void copyProperties(Object source, Object target) {
        if (source != null) {
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
    }

    public static void copyProperties(Object source, Object target, String[] ignoreProperties) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
    }

    public static <S, T> T copyRtnProperties(S source, T target) {
        if (source == null) {
            return null;
        }
        BeanHelper.copyProperties(source, target);
        return target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportProperties(Object source, Object target, boolean ignoreType, boolean convertType, String[] ignoreProperties) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(target.getClass());
        List<String> ignoreList = ignoreProperties == null ? null : Arrays.asList(ignoreProperties);
        for (int i = 0; i < targetPds.length; ++i) {
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = targetPds[i];
            if (targetPd.getWriteMethod() == null || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Method readMethod = sourcePd.getReadMethod();
                if ((targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName())) && !Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                Class<?> rt = readMethod.getReturnType();
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                Class<?> wt = writeMethod.getParameterTypes()[0];
                boolean same = readMethod.getReturnType().equals(writeMethod.getParameterTypes()[0]);
                if (!same) {
                    if (convertType) {
                        if (value != null) {
                            if (value instanceof String && Number.class.isAssignableFrom(wt)) {
                                if (StringUtils.isEmpty((Object)((String)value))) {
                                    value = null;
                                } else {
                                    Method valueOf = wt.getMethod("valueOf", String.class);
                                    value = valueOf.invoke(null, value);
                                }
                            } else {
                                if (!Number.class.isAssignableFrom(rt) || !String.class.isAssignableFrom(wt)) throw new FatalBeanException("Could not convert type: " + readMethod.getReturnType() + " ==> " + writeMethod.getParameterTypes()[0] + ", property: " + targetPd.getName());
                                value = value.toString();
                            }
                        }
                    } else if (ignoreType) continue;
                }
                writeMethod.invoke(target, value);
                continue;
            }
            catch (Exception ex) {
                throw new FatalBeanException("Could not copy properties from source to target", (Throwable)ex);
            }
        }
    }

    public static <S, T> T exportProperties(S source, Class<T> rtType, String[] ignoreProperties) throws Exception {
        try {
            return BeanHelper.exportProperties(source, rtType, false, true, ignoreProperties);
        }
        catch (Exception e) {
            throw new Exception("BeanRefUtils copyProperties fail.", e);
        }
    }

    public static <S, T> T exportProperties(S source, Class<T> rtType, boolean ignoreType, boolean convertType, String[] ignoreProperties) throws Exception {
        try {
            return BeanHelper.exportRtnProperties(source, rtType.newInstance(), ignoreType, convertType, ignoreProperties);
        }
        catch (Exception e) {
            throw new Exception("BeanRefUtils copyProperties fail.", e);
        }
    }

    public static <S, T> T exportProperties(S source, T target) throws Exception {
        try {
            return BeanHelper.exportRtnProperties(source, target, false, true, null);
        }
        catch (Exception e) {
            throw new Exception("BeanRefUtils copyProperties fail.", e);
        }
    }

    public static <S, T> T exportRtnProperties(S source, T target, boolean ignoreType, boolean auroTrans, String[] ignoreProperties) {
        if (source == null) {
            return null;
        }
        BeanHelper.exportProperties(source, target, ignoreType, auroTrans, ignoreProperties);
        return target;
    }

    public static interface PropertiesHandler<S, T> {
        public T getValue(S var1) throws Exception;
    }
}

