/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtil {
    public static Date to24Hour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static String parseTimeToPNet(Date dateTime) {
        return DateUtil.toDate(dateTime).replace(" ", "T") + "+08:00";
    }

    public static String toDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public static String toDate(Date datetime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return null == datetime ? "" : sdf.format(datetime);
    }

    public static String toDateShort(Date datetime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return null == datetime ? "" : sdf.format(datetime);
    }

    public static String toDateYear(Date datetime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return null == datetime ? "" : sdf.format(datetime);
    }

    public static String toDate(Date datetime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return null == datetime ? "" : sdf.format(datetime);
    }

    public static String toDate(long datetime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(datetime);
    }

    public static String toDate(long datetime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(datetime);
    }

    public static String toDate(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date());
    }

    public static String toDate(String format, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        return sdf.format(new Date());
    }

    public static String toDate(Date datetime, String format, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        return null == datetime ? "" : sdf.format(datetime);
    }

    public static Integer getCurrentNumberByTwoDigits() {
        int mm = Integer.valueOf(DateUtil.toDate("MM"));
        if (mm < 5) {
            return Integer.valueOf(DateUtil.toDate("yyyy")) + 1 - 2000;
        }
        return Integer.valueOf(DateUtil.toDate("yyyy")) + 2 - 2000;
    }

    public static String getCurrentNumberByFourDigits() {
        int mm = Integer.valueOf(DateUtil.toDate("MM"));
        if (mm < 5) {
            return DateUtil.toDate("yyyy");
        }
        return String.valueOf(Integer.valueOf(DateUtil.toDate("yyyy")) + 1);
    }

    public static boolean isValidDate(String str, String formatStr) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static Date parseDate(String str, String formatStr) {
        Date convertSuccess;
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        try {
            format.setLenient(false);
            convertSuccess = format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = null;
        }
        return convertSuccess;
    }

    public static Date getCurrDateStartTime() {
        Calendar ca = Calendar.getInstance();
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        return ca.getTime();
    }

    public static Date getCurrDateEndTime() {
        Calendar ca = Calendar.getInstance();
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        return ca.getTime();
    }

    public static Date getCurrWeekFristDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(7, 2);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        return ca.getTime();
    }

    public static Date getCurrWeeklastDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(7, 1);
        ca.set(11, 23);
        ca.set(11, 59);
        ca.set(11, 59);
        return ca.getTime();
    }

    public static Date string2Date(String stringDate, String pas) {
        Date reDate;
        try {
            reDate = new SimpleDateFormat(pas).parse(stringDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            reDate = null;
        }
        return reDate;
    }

    public static Date string2Date(String stringDate) {
        return DateUtil.string2Date(stringDate, "yyyyMMdd");
    }

    public static Date stringToDate(String stringDate) {
        return DateUtil.string2Date(stringDate, "yyyy-MM-dd");
    }

    public static Date addDays(Date date, int days) {
        if (null == date) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addHour(Date date, int Hour) {
        if (null == date) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, Hour);
        return cal.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static List<String> getWeekendOfMonth(Date date, String fomat) {
        if (date == null) {
            return null;
        }
        ArrayList<String> weekendList = new ArrayList<String>();
        for (int i = 1; i <= 30; ++i) {
            Calendar calendar = DateUtil.toCalendar(DateUtil.addDays(date, i));
            int week = calendar.get(7);
            if (week != 1 && week != 7) continue;
            weekendList.add(DateUtil.toDate(calendar.getTime(), fomat));
        }
        return weekendList;
    }

    public static Date getMonthLastDay(Integer year, Integer month) {
        if (0 == month) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, year);
            cal.set(6, cal.get(6) - 1);
            return cal.getTime();
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static String getMonthLastDayStr(Integer year, Integer month) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(DateUtil.getMonthLastDay(year, month));
    }

    public static Date getMonthFristDay(int month) {
        Calendar ca = Calendar.getInstance();
        ca.set(ca.get(1), month - 1, 1, 0, 0, 0);
        return ca.getTime();
    }

    public static Date getMonthLastDay(int month) {
        Calendar ca = Calendar.getInstance();
        ca.set(2, month - 1);
        int lastDay = ca.getActualMaximum(5);
        ca.set(5, lastDay);
        return ca.getTime();
    }

    public static Date getCurrMonthFristDay() {
        Calendar ca = Calendar.getInstance();
        ca.add(2, 0);
        ca.set(5, 1);
        return ca.getTime();
    }

    public static Date getCurrMonthLastDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return ca.getTime();
    }

    public static int getCurrYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int getCurrDay() {
        return Calendar.getInstance().get(5);
    }

    public static int getCurrHour() {
        return Calendar.getInstance().get(11);
    }

    public static long currentTime() {
        return System.currentTimeMillis();
    }

    public static boolean compareDate(Date date1, Date date2) {
        return date1.getTime() > date2.getTime();
    }
}

