/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.simm.common.utils.PropertiesUtil;
import com.simm.common.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class OssUtil {
    public static final String ALIYUN_OSS_PATH_TEMPLATE = "hive/template/";
    private static String endpoint = PropertiesUtil.getKey("endpoint");
    private static final String url = PropertiesUtil.getKey("ossUrl");
    private static String accessKeyId = PropertiesUtil.getKey("aliAppId");
    private static String accessKeySecret = PropertiesUtil.getKey("aliAppSecret");
    private static String bucketName = PropertiesUtil.getKey("bucketName");
    private static OSSClient ossClient;

    public static void init() {
        ClientConfiguration conf = new ClientConfiguration();
        ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret, conf);
    }

    public static void shutdown() {
        ossClient.shutdown();
    }

    public static boolean existAndCreateBucket(String bucketName) {
        OssUtil.init();
        if (ossClient.doesBucketExist(bucketName)) {
            return true;
        }
        ossClient.createBucket(bucketName);
        OssUtil.shutdown();
        return false;
    }

    public static BucketInfo getBucketInfo(String bucketName) {
        OssUtil.init();
        BucketInfo info = ossClient.getBucketInfo(bucketName);
        OssUtil.shutdown();
        return info;
    }

    public static List<OSSObjectSummary> getBucketObjectInfo(String bucketName) {
        OssUtil.init();
        ObjectListing objectListing = ossClient.listObjects(bucketName);
        List objectSummary = objectListing.getObjectSummaries();
        OssUtil.shutdown();
        return objectSummary;
    }

    public static String uploadObject(InputStream is, String filePath, String bucketNameCite) throws UnsupportedEncodingException {
        OssUtil.init();
        String fileUrl = null;
        if (StringUtil.isBlank(bucketNameCite)) {
            ossClient.putObject(bucketName, filePath, is);
            fileUrl = "http://" + bucketName + "." + url + filePath;
        } else {
            ossClient.putObject(bucketNameCite, filePath, is);
            fileUrl = "http://" + bucketNameCite + "." + url + filePath;
        }
        OssUtil.shutdown();
        return fileUrl;
    }

    public static String uploadObject(String serverFilePath, String filePath, String bucketNameCite) {
        OssUtil.init();
        String fileUrl = null;
        if (StringUtil.isBlank(bucketNameCite)) {
            ossClient.putObject(bucketName, filePath, new File(serverFilePath));
            fileUrl = "http://" + bucketName + "." + url + filePath;
        } else {
            ossClient.putObject(bucketNameCite, filePath, new File(serverFilePath));
            fileUrl = "http://" + bucketNameCite + "." + url + filePath;
        }
        OssUtil.shutdown();
        return fileUrl;
    }

    public static StringBuilder downloadObject(String fileName, String bucketNameCite) throws IOException {
        String line;
        OssUtil.init();
        OSSObject ossObject = null;
        ossObject = StringUtil.isBlank(bucketNameCite) ? ossClient.getObject(bucketName, fileName) : ossClient.getObject(bucketNameCite, fileName);
        InputStream inputStream = ossObject.getObjectContent();
        StringBuilder objectContent = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            objectContent.append(line);
        }
        reader.close();
        inputStream.close();
        OssUtil.shutdown();
        return objectContent;
    }

    public static void deleteObject(String fileName, String bucketNameCite) {
        OssUtil.init();
        if (StringUtil.isNotBlank(bucketNameCite)) {
            ossClient.deleteObject(bucketNameCite, fileName);
        }
        OssUtil.shutdown();
    }
}

