package com.simm.common.utils;

import java.util.Random;

/**
 * 
 * @Description 数字处理
 *
 * @author YingJH
 * @Date 2017年9月21日
 * @version v1.0
 */
public class NumberUtil {

	public static boolean isNumeric(String str) {
		for (int i = str.length(); --i >= 0;) {
			int chr = str.charAt(i);
			if (chr < 48 || chr > 57)
				return false;
		}
		return true;
	}

	public static boolean isNotNZ(Integer i) {
		return (null != i && i > 0);
	}

	/**
	 * 判断字符串是否是整数
	 */
	public static boolean isInteger(String value) {
		try {
			Integer.parseInt(value);
			return true;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	/**
	 * 判断字符串是否是浮点数
	 */
	public static boolean isDouble(String value) {
		try {
			Double.parseDouble(value);
			if (value.contains("."))
				return true;
			return false;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	public static boolean isNum(String str) {
		return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
	}
	
	/**
	 * 随机生成数字
	 * 
	 * @param i
	 * @return
	 */
	public static String randomNumber(int i) {
		String str;

		str = "";
		while (str.length() < i) {
			str += new Random().nextInt(9);
		}

		return str;
	}

	public static void main(String[] args) {
		System.out.println(NumberUtil.isNum("2.0"));

	}

}
