package com.simm.common.utils.wechat;

import com.alibaba.fastjson.JSONObject;
import com.simm.common.utils.HttpUtil;
import com.simm.common.utils.PropertiesUtil;

/**
 * 
 * @Description 微信工具类
 *
 * @author YingJH
 * @Date 2018年1月24日
 * @version v1.0
 */
public class WechatUtil {

	public final static String APPID = PropertiesUtil.getKey("appId").trim();
	public final static String APPSECRET = PropertiesUtil.getKey("appSecret").trim();

	/**
	 * 
	 * @Description 获取微信企业用户的openId
	 *
	 * @author YingJH
	 * @Date 2018年1月24日
	 * @param code
	 * @param token
	 * @return
	 */
	public static String getUserId(String code, String token) {
		String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=%s&code=%s",
				token, code);
		String result = HttpUtil.HttpConnect(url);
		JSONObject object = JSONObject.parseObject(result);
		return (String) object.get("UserId");
	}

	/**
	 * 
	 * @Description 获取微信企业号Token
	 *
	 * @author YingJH
	 * @Date 2018年1月24日
	 * @return
	 */
	public static String getToken() {
		String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s", APPID,
				APPSECRET);
		String wxToken = HttpUtil.HttpConnect(url);
		JSONObject object = JSONObject.parseObject(wxToken);
		return (String) object.get("access_token");
	}

	/**
	 * 
	 * @Description 生成用于获取access_token的Code的Url
	 *
	 * @author YingJH
	 * @Date 2018年1月24日
	 * @param redirectUrl
	 * @return
	 */
	public static String getRequestCodeUrl(String redirectUrl) {
		return String
				.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect",
						APPID, redirectUrl, "snsapi_base", "1");
	}

}