package com.simm.common.vo;

import org.springframework.beans.BeanUtils;

import com.simm.common.bean.BaseBean;
import com.simm.common.utils.DateUtil;


/**
 * 
 * @Description 父级VO,所有的VO都需继承该类
 *
 * @author YingJH
 * @Date 2017年9月22日
 * @version v1.0
 */
public class BaseVO implements java.io.Serializable {
	private static final long serialVersionUID = 1L;
	
    private String createBy;

    private String createTime;

    private String lastUpdateBy;

    private String lastUpdateTime;
    
    private String remark;
	
	public void conversion(BaseBean bean) {
		this.setCreateTime(DateUtil.toDate(bean.getCreateTime()));
		this.setLastUpdateTime(DateUtil.toDate(bean.getLastUpdateTime()));
		BeanUtils.copyProperties(bean, this);
	}

	public String getRemark() {
		return remark;
	}



	public void setRemark(String remark) {
		this.remark = remark;
	}



	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getCreateTime() {
		return createTime;
	}

	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	public String getLastUpdateBy() {
		return lastUpdateBy;
	}

	public void setLastUpdateBy(String lastUpdateBy) {
		this.lastUpdateBy = lastUpdateBy;
	}

	public String getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(String lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}
	
}
