package com.simm.common.constant;

/**
 * 
 * @Description json 返回码
 * @author JHYing
 * @time 2017年5月25日 下午3:00:34
 */
public interface MessageConstant {
	/**
	 * 获取成功
	 */
	String SUCCESS = "200";

	/**
	 * 参数不正确
	 */
	String FAILURE = "500";

	/**
	 * 失败
	 */
	String VALIDATE_PARAMETER_ERROR = "501";

	/**
	 * 502,服务器有误,程序员小哥开小差
	 */
	String SERVER_ERROR = "502";
	
	/**
	 * 验证码发送成功
	 */
	String CODE_SEND_SCUESS = "503";
	
	/**
	 * 验证码发送失败
	 */
	String CODE_SEND_ERROR = "505";

	/**
	 * 验证码错误
	 */
	String CHECK_ERROR = "507";
	
	/**
	 * 用户未登录&Session过期
	 */
	String SESSION_EXPIRE = "600";

	/**
	 * 用户没有权限
	 */
	String AUTHENTICATION_EXPIRE = "700";

	String SHOW_ERROR_INFO = "9999";

	// *********正则表达式begin*******

	/**
	 * 手机号码
	 */
	String REG_PHONE = "^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";

	/**
	 * 邮箱
	 */
	String REG_EMAIL = "^([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\.][A-Za-z]{2,3}([\\.][A-Za-z]{2})?$";

	/**
	 * 汉字
	 */
	String REG_CHINESE = "[\u4E00-\u9FA5]";

	/**
	 * 身份证
	 */
	String REG_IDENTIFY_CARD = "(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])";

	/**
	 * 移动手机号
	 */
	String MOBILE_PHONE = "^((13[4-9])|(147)|(15[0-2,7-9])|(178)|(18[2-4,7-8]))\\d{8}$";

	/**
	 * 联通手机号
	 */
	String UNICOM_PHONE = "^((13[0-2])|(145)|(176)|(15[5-6])|(18[5-6]))\\d{8}$";

	/**
	 * 电信手机号
	 */
	String TELECOM_PHONE = "^((133)|(153)|(177)|(18[0-1,9]))\\d{8}$";

	// *********正则表达式end*********

}
