package com.simm.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/**
 * 
 * @Description 日期时间工具类
 *
 * @author YingJH
 * @Date 2017年9月21日
 * @version v1.0
 */
public class DateUtil {

	/**
	 * 
	 * @Description y=年 u=周
	 *
	 * @author YingJH
	 * @Date 2018年5月24日
	 * @param yu
	 * @return
	 */
	public static String getDateByWeekCount(String yu){
		StringBuilder sb = new StringBuilder();
		String[] split = yu.split("-");
		if(split == null || split.length <2) return null;
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(split[0])); // 2016年
		cal.set(Calendar.WEEK_OF_YEAR, Integer.parseInt(split[1])); // 设置为2016年的第10周
		cal.set(Calendar.DAY_OF_WEEK, 2); // 1表示周日，2表示周一，7表示周六
		Date date = cal.getTime();
		sb.append(toDateShort(date)).append("~");
		cal.set(Calendar.WEEK_OF_YEAR, Integer.parseInt(split[1])+1);
		cal.set(Calendar.DAY_OF_WEEK, 1); // 1表示周日，2表示周一，7表示周六
		date = cal.getTime();
		sb.append(toDateShort(date));
		return sb.toString();
	}
	
	public static Date to24Hour(Date date){
		Calendar c = Calendar.getInstance();
		c.setTime(date);
		c.set(Calendar.HOUR_OF_DAY, 23);
		c.set(Calendar.MINUTE, 59);
		c.set(Calendar.SECOND, 59);
		return c.getTime();
	}
	
	// yyyy-MM-ddTHH:mm:ss.SSS+Z:00
	public static String parseTimeToPNet(Date dateTime) {
		return DateUtil.toDate(dateTime).replace(" ", "T") + "+08:00";
	}

	public static String toDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(new Date());
	}

	public static String toDate(Date datetime) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return null == datetime ? null : sdf.format(datetime);
	}
	
	public static String toDateShort(Date datetime) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return null == datetime ? "" : sdf.format(datetime);
	}
	
	public static String toTimeStamp(Date datetime) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		return null == datetime ? "" : sdf.format(datetime);
	}
	
	public static String toDateYear(Date datetime) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
		return null == datetime ? "" : sdf.format(datetime);
	}

	public static String toDate(Date datetime, String format) {
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return null == datetime ? "" : sdf.format(datetime);
	}

	public static String toDate(long datetime) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(datetime);
	}
	
	public static String toDate(long datetime, String format) {
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return sdf.format(datetime);
	}

	public static String toDate(String format) {
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return sdf.format(new Date());
	}

	public static String toDate(String format, Locale locale) {
		SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
		return sdf.format(new Date());
	}

	public static String toDate(Date datetime, String format, Locale locale) {
		SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
		return null == datetime ? "" : sdf.format(datetime);
	}

	/**
	 * 
	 * @Description 获取当前展会届数--->二位
	 *
	 * @author YingJH
	 * @Date 2017年11月7日
	 *
	 */
	public static Integer getCurrentNumberByTwoDigits() {
		int mm = Integer.valueOf(toDate("MM"));
		if (mm < 5) {
			return Integer.valueOf(toDate("yyyy")) + 1-2000;
		} else {
			return Integer.valueOf(toDate("yyyy")) + 2-2000;
		}
	}
	
	/**
	 * 
	 * @Description 获取当前展会届数--->四位
	 *
	 * @author YingJH
	 * @Date 2017年11月7日
	 *
	 */
	public static String getCurrentNumberByFourDigits() {
		int mm = Integer.valueOf(toDate("MM"));
		if (mm < 5) {
			return toDate("yyyy");
		} else {
			return String.valueOf(Integer.valueOf(toDate("yyyy")) + 1);
		}
	}
	

	public static boolean isValidDate(String str, String formatStr) {
		boolean convertSuccess = true;
		SimpleDateFormat format = new SimpleDateFormat(formatStr);
		try {
			format.setLenient(false);
			format.parse(str);
		} catch (ParseException e) {
			convertSuccess = false;
		}
		return convertSuccess;
	}

	public static Date parseDate(String str, String formatStr) {
		Date convertSuccess;
		SimpleDateFormat format = new SimpleDateFormat(formatStr);
		try {
			format.setLenient(false);
			convertSuccess = format.parse(str);
		} catch (ParseException e) {
			convertSuccess = null;
		}
		return convertSuccess;
	}

	/**
	 * 获取截至今天0.0.0
	 * 
	 * @return
	 */
	public static Date getCurrDateStartTime() {
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.HOUR_OF_DAY, 0);
		ca.set(Calendar.MINUTE, 0);
		ca.set(Calendar.SECOND, 0);
		return ca.getTime();
	}

	/**
	 * 获取截至今天23.59.59
	 * 
	 * @return
	 */
	public static Date getCurrDateEndTime() {
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.HOUR_OF_DAY, 23);
		ca.set(Calendar.MINUTE, 59);
		ca.set(Calendar.SECOND, 59);
		return ca.getTime();
	}

	/**
	 * 获取本周第一天（周一）
	 * 
	 * @return
	 */
	public static Date getCurrWeekFristDay() {
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
		ca.set(Calendar.HOUR_OF_DAY, 0);
		ca.set(Calendar.MINUTE, 0);
		ca.set(Calendar.SECOND, 0);
		return ca.getTime();
	}

	/**
	 * 获取本周第一天（周日）
	 * 
	 * @return
	 */
	public static Date getCurrWeeklastDay() {
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
		ca.set(Calendar.HOUR_OF_DAY, 23);
		ca.set(Calendar.HOUR_OF_DAY, 59);
		ca.set(Calendar.HOUR_OF_DAY, 59);
		return ca.getTime();
	}

	/**
	 * 字符串转换成时间
	 * 
	 * @param stringDate
	 * @return
	 */
	public static Date string2Date(String stringDate, String pas) {
		Date reDate;

		try {
			reDate = new SimpleDateFormat(pas).parse(stringDate);
		} catch (ParseException e) {
			e.printStackTrace();
			reDate = null;
		}

		return reDate;
	}
	
	/* 
     * 将时间戳转换为时间
     */
    public static Date stampToDate(String s){
    	 String res;
         SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         long lt = new Long(s);
         Date date = new Date(lt);
         res = simpleDateFormat.format(date);
         try {
			return simpleDateFormat.parse(res);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;  
    }
    
	/**
	 * 字符串转换成时间
	 * 
	 * @param stringDate
	 * @return
	 */
	public static Date string2Date(String stringDate) {
		return string2Date(stringDate, "yyyyMMdd");
	}
	
	/**
	 * 字符串转换成时间
	 * 
	 * @param stringDate
	 * @return
	 */
	public static Date stringToDate(String stringDate) {
		return string2Date(stringDate, "yyyy-MM-dd");
	}
	
	/**
	 * 字符串转换成时间
	 * 
	 * @param stringDate
	 * @return
	 */
	public static Date stringToDateLong(String stringDate) {
		return string2Date(stringDate, "yyyy-MM-dd HH:mm:ss");
	}

	/**
	 * 日期添加
	 * 
	 * @param date
	 * @param days
	 * @return
	 */
	public static Date addDays(Date date, int days) {
		if (null == date) {
			date = new Date();
		}

		Calendar cal = Calendar.getInstance();
		cal.setTime(date);

		cal.add(Calendar.DATE, days); // minus number would decrement the days
		return cal.getTime();
	}

	/**
	 * 时间添加
	 * 
	 * @param date
	 * @param days
	 * @return
	 */
	public static Date addHour(Date date, int Hour) {

		if (null == date) {
			date = new Date();
		}

		Calendar cal = Calendar.getInstance();
		cal.setTime(date);

		cal.add(Calendar.HOUR_OF_DAY, Hour);
		return cal.getTime();
	}

	/**
	 * Date类型转换成Calendar类型
	 * 
	 * @param date
	 * @param days
	 * @return
	 */
	public static Calendar toCalendar(Date date) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		return calendar;
	}

	/**
	 * 获取一个月内的周末
	 * 
	 * @param date
	 * @param days
	 * @return
	 */
	public static List<String> getWeekendOfMonth(Date date, String fomat) {
		if (date == null) {
			return null;
		}
		List<String> weekendList = new ArrayList<String>();
		for (int i = 1; i <= 30; i++) {
			Calendar calendar = DateUtil.toCalendar(DateUtil.addDays(date, i));
			int week = calendar.get(Calendar.DAY_OF_WEEK);
			if (week == 1 || week == 7) {
				weekendList.add(DateUtil.toDate(calendar.getTime(), fomat));
			}
		}
		return weekendList;
	}

	/**
	 * 获取一个月的最后一天
	 * 
	 * @param year
	 * @param month
	 * @return
	 */
	public static Date getMonthLastDay(Integer year, Integer month) {

		if (0 == month) {
			Calendar cal = Calendar.getInstance();
			// 设置年份
			cal.set(Calendar.YEAR, year);
			cal.set(Calendar.DAY_OF_YEAR, cal.get(Calendar.DAY_OF_YEAR) - 1);
			return cal.getTime();
		} else {
			Calendar cal = Calendar.getInstance();
			// 设置年份
			cal.set(Calendar.YEAR, year);
			// 设置月份
			cal.set(Calendar.MONTH, month - 1);
			// 获取某月最大天数
			int lastDay = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
			// 设置日历中月份的最大天数
			cal.set(Calendar.DAY_OF_MONTH, lastDay);
			return cal.getTime();
		}

	}

	/**
	 * 获取一个月的最后一天
	 * 
	 * @param year
	 * @param month
	 * @return
	 */
	public static String getMonthLastDayStr(Integer year, Integer month) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(getMonthLastDay(year, month));
	}

	/**
	 * 获取当月第一天
	 * 
	 * @return
	 */
	public static Date getMonthFristDay(int month) {
		Calendar ca = Calendar.getInstance();
		ca.set(ca.get(Calendar.YEAR), (month - 1), 1, 0, 0, 0);
		return ca.getTime();
	}

	/**
	 * 获取当月最后一天
	 * 
	 * @return
	 */
	public static Date getMonthLastDay(int month) {
		Calendar ca = Calendar.getInstance();
		// ca.set(ca.get(Calendar.YEAR), (month - 1),
		// ca.getActualMaximum(Calendar.DAY_OF_MONTH), 23, 59, 59);
		ca.set(Calendar.MONTH, month - 1);
		int lastDay = ca.getActualMaximum(Calendar.DAY_OF_MONTH);
		ca.set(Calendar.DAY_OF_MONTH, lastDay);
		return ca.getTime();
	}

	/**
	 * 获取当月第一天
	 * 
	 * @return
	 */
	public static Date getCurrMonthFristDay() {
		Calendar ca = Calendar.getInstance();
		ca.add(Calendar.MONTH, 0);
		ca.set(Calendar.DAY_OF_MONTH, 1);
		return ca.getTime();
	}

	/**
	 * 获取当月最后一天
	 * 
	 * @return
	 */
	public static Date getCurrMonthLastDay() {
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
		return ca.getTime();
	}

	/**
	 * 获取当年
	 * 
	 * @return
	 */
	public static int getCurrYear() {
		return Calendar.getInstance().get(Calendar.YEAR);
	}

	/**
	 * 获取当月
	 * 
	 * @return
	 */
	public static int getCurrMonth() {
		return Calendar.getInstance().get(Calendar.MONTH) + 1;
	}

	/**
	 * 获取当天
	 * 
	 * @return
	 */
	public static int getCurrDay() {
		return Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
	}

	/**
	 * 获取当前小时
	 * 
	 * @return
	 */
	public static int getCurrHour() {
		return Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
	}
	
	public static long currentTime(){
		return System.currentTimeMillis();
	}
	
	/**
	 * 比较时间大小
	 * @return
	 */
	public static boolean compareDate(Date date1,Date date2) {
		if(date1.getTime()>date2.getTime()){
			return true;
		}
		return false;
	}

}