package com.simm.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;

public class JsonUtil {
	
	/**
	 * 用fastjson 将json字符串解析为一个 JavaBean
	 * 
	 * @param <T>
	 *
	 * @param jsonString
	 * @param cls
	 * @returnx
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static <T> T parseObject(String jsonString, Class cls) {
		T t = null;
		try {
			t = (T) JSON.parseObject(jsonString, cls);
		} catch (Exception e) {
		}
		return t;
	}
	
	public static String toJSONString(Object obj) {
		return JSON.toJSONString(obj);
	}

	/**
	 * 用fastjson 将json字符串 解析成为一个 List 及 List
	 *
	 * @param jsonString
	 * @param cls
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List parseArray(String jsonString, Class cls) {
		List list = new ArrayList();
		try {
			list = JSON.parseArray(jsonString, cls);
		} catch (Exception e) {
		}
		return list;
	}

	/**
	 * 用fastjson 将json字符串 解析成为一个 List 及 List
	 *
	 * @param jsonString
	 * @param cls
	 * @return
	 */
	@SuppressWarnings({ "rawtypes" })
	public static List getArrayJson(String jsonString) {
		List list = new ArrayList();
		try {
			list = (List) JSON.parseArray(jsonString);
		} catch (Exception e) {
		}
		return list;
	}
	
	
	@SuppressWarnings("rawtypes")
	public static Map parseMap(String jsonString) {
	    return (Map)JSON.parse(jsonString);
	}
	
	public static <T> List<T> jsonArrStr2List(String jsonArrStr, Class<T> pojoClass){
        return JSON.parseArray(jsonArrStr, pojoClass);
    }
	
	/**
     * JSON字符串转换为对象
     * @param json
     * @param pojoCalss
     * @return
     */
    public static <T> T jsonStr2Object(String jsonStr, Class<T> pojoCalss){
        return JSON.parseObject(jsonStr, pojoCalss);
    }
    
    public static String makeResJson(String jsonpCallback, Object resMap) {
		String jsonString = JSON.toJSONString(resMap);
		if(StringUtil.isEmpty(jsonpCallback)) jsonpCallback="jsonpCallback";
		return jsonpCallback + "([" + jsonString + "])";
	}
}
