package com.simm.common.utils;

import java.security.MessageDigest;
import java.util.UUID;

import org.apache.commons.codec.digest.DigestUtils;

/**
 * 
 * @Description MD5
 *
 * @author YingJH
 * @Date 2017年9月21日
 * @version v1.0
 */
public class Md5Util {

	public final static String getMd5Msg(String s) {
		char hexDigits[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };
		try {
			byte[] strTemp = s.getBytes();
			MessageDigest mdTemp = MessageDigest.getInstance("MD5");
			mdTemp.update(strTemp);
			byte[] md = mdTemp.digest();
			int j = md.length;
			char str[] = new char[j * 2];
			int k = 0;
			for (int i = 0; i < j; i++) {
				byte byte0 = md[i];
				str[k++] = hexDigits[byte0 >>> 4 & 0xf];
				str[k++] = hexDigits[byte0 & 0xf];
			}
			return new String(str).toLowerCase();
		} catch (Exception e) {
			return null;
		}
	}
	
	public final static String getUUID(){
		return getMd5Msg(UUID.randomUUID().toString()).toUpperCase();
	}
	
	public static String md5(String text){
		return DigestUtils.md5Hex(text);
	}
	
	public static String md5(String text, String key){
		return DigestUtils.md5Hex(text+key);
	}
	
}
