package com.simm.common.utils.page;

import java.io.Serializable;

/**
 * 
 * @Description 数据库、内存分页对象. 包含当前页数据及分页信息， T为返回列表中的类型，P为入参的类型。
 *
 * @author YingJH
 * @Date 2017年11月10日
 * @version v1.0
 */
public class PageParam<P> implements Serializable {
	private static final long serialVersionUID = 1L;

	public final static Integer DEFAULT_PAGE_No = 1;
	public final static Integer DEFAULT_PAGE_SIZE = 10;

	/**
	 * 以Bean形式包装查询条件（不含参数：页号，每页记录数，总记录数，总分页数，是否有前一页，否有下一页）
	 */
	private P p;

	/**
	 * 跳转页数，页数是从第一页是从1开始计算的
	 */
	private Integer pageNo = DEFAULT_PAGE_No;

	/**
	 * 每页的记录数(每页尺寸)
	 */
	private Integer pageSize = DEFAULT_PAGE_SIZE;

	/**
	 * 总记录数
	 */
	private Integer dataTotal = 0;

	public PageParam() {

	}

	public PageParam(P p, Integer pageNo, Integer pageSize) {
		super();
		this.p = p;
		if (pageNo == null) {
			this.pageNo = 1;
		} else {
			this.pageNo = pageNo;
		}
		if (pageSize == null) {
			this.pageSize = 10;
		} else {
			this.pageSize = pageSize;
		}
	}

	public P getP() {
		return p;
	}

	public void setP(P p) {
		this.p = p;
	}

	public Integer getPageNo() {
		return pageNo;
	}

	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getDataTotal() {
		return dataTotal;
	}

	public void setDataTotal(Integer dataTotal) {
		this.dataTotal = dataTotal;
	}

	@Override
	public String toString() {
		return "PageParam [p=" + p + ", pageNo=" + pageNo + ", pageSize=" + pageSize + ", dataTotal=" + dataTotal + "]";
	}

}
