/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.simm.common.utils.PropertiesUtil;
import com.simm.common.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class OssUtil {
    public static final String ALIYUN_OSS_PATH_TEMPLATE = "hive/template/";
    private static String endpoint = PropertiesUtil.getKey("endpoint");
    private static final String url = PropertiesUtil.getKey("ossUrl");
    private static String accessKeyId = PropertiesUtil.getKey("aliAppId");
    private static String accessKeySecret = PropertiesUtil.getKey("aliAppSecret");
    private static String bucketName = PropertiesUtil.getKey("bucketName");

    public static OSSClient getOSSClient() {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        return ossClient;
    }

    public static void shutdown(OSSClient ossClient) {
        ossClient.shutdown();
    }

    public static boolean existAndCreateBucket(String bucketName) {
        OSSClient ossClient = OssUtil.getOSSClient();
        if (ossClient.doesBucketExist(bucketName)) {
            return true;
        }
        ossClient.createBucket(bucketName);
        OssUtil.shutdown(ossClient);
        return false;
    }

    public static BucketInfo getBucketInfo(String bucketName) {
        OSSClient ossClient = OssUtil.getOSSClient();
        BucketInfo info = ossClient.getBucketInfo(bucketName);
        OssUtil.shutdown(ossClient);
        return info;
    }

    public static List<OSSObjectSummary> getBucketObjectInfo(String bucketName) {
        OSSClient ossClient = OssUtil.getOSSClient();
        ObjectListing objectListing = ossClient.listObjects(bucketName);
        List objectSummary = objectListing.getObjectSummaries();
        OssUtil.shutdown(ossClient);
        return objectSummary;
    }

    public static String uploadObject(InputStream is, String filePath, String bucketNameCite) throws UnsupportedEncodingException {
        OSSClient ossClient = OssUtil.getOSSClient();
        String fileUrl = null;
        if (StringUtil.isBlank(bucketNameCite)) {
            ossClient.putObject(bucketName, filePath, is);
            fileUrl = "http://" + bucketName + "." + url + filePath;
        } else {
            ossClient.putObject(bucketNameCite, filePath, is);
            fileUrl = "http://" + bucketNameCite + "." + url + filePath;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        OssUtil.shutdown(ossClient);
        return fileUrl;
    }

    public static String uploadObject(String serverFilePath, String filePath, String bucketNameCite) {
        OSSClient ossClient = OssUtil.getOSSClient();
        String fileUrl = null;
        if (StringUtil.isBlank(bucketNameCite)) {
            ossClient.putObject(bucketName, filePath, new File(serverFilePath));
            fileUrl = "http://" + bucketName + "." + url + filePath;
        } else {
            ossClient.putObject(bucketNameCite, filePath, new File(serverFilePath));
            fileUrl = "http://" + bucketNameCite + "." + url + filePath;
        }
        OssUtil.shutdown(ossClient);
        return fileUrl;
    }

    public static StringBuilder downloadObject(String fileName, String bucketNameCite) throws IOException {
        String line;
        OSSClient ossClient = OssUtil.getOSSClient();
        OSSObject ossObject = null;
        ossObject = StringUtil.isBlank(bucketNameCite) ? ossClient.getObject(bucketName, fileName) : ossClient.getObject(bucketNameCite, fileName);
        InputStream inputStream = ossObject.getObjectContent();
        StringBuilder objectContent = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            objectContent.append(line);
        }
        reader.close();
        inputStream.close();
        OssUtil.shutdown(ossClient);
        return objectContent;
    }

    public static void deleteObject(String fileName, String bucketNameCite) {
        OSSClient ossClient = OssUtil.getOSSClient();
        if (StringUtil.isNotBlank(bucketNameCite)) {
            ossClient.deleteObject(bucketNameCite, fileName);
        }
        OssUtil.shutdown(ossClient);
    }
}

