package com.simm.common.resp;

import java.io.Serializable;

import com.simm.common.constant.MessageConstant;
import com.simm.common.utils.PropertiesUtil;

/**
 * 
 * @Description 请求结果封装模型
 * @author JHYing
 * @time 2017年5月25日 下午3:09:38
 */
public class Resp implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2169140102785610954L;

	// 返回码
	private String code;

	// 信息内容
	private String message;

	// 数据对象
	private Object data;
	
	public Resp() {
	}

	public Resp(String code, String message, Object data) {
		this.code = code;
		this.message = message;
		this.data = data;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	/**
	 * 
	 * @Description 返回json
	 * @author JHYing
	 * @time 2017年5月25日 下午3:01:57
	 * @return
	 */
	public static Resp success() {
		return new Resp(MessageConstant.SUCCESS, PropertiesUtil.getMessage(MessageConstant.SUCCESS), null);
	}

	/**
	 * 
	 * @Description 返回json
	 * @author JHYing
	 * @time 2017年5月25日 下午3:09:53
	 * @param data
	 * @return
	 */
	public static Resp success(Object data) {
		return new Resp(MessageConstant.SUCCESS, PropertiesUtil.getMessage(MessageConstant.SUCCESS), data);
	}

	public static Resp success(String message, Object data) {
		return new Resp(MessageConstant.SUCCESS, message, data);
	}

	public static Resp failure() {
		return new Resp(MessageConstant.VALIDATE_PARAMETER_ERROR,
				PropertiesUtil.getMessage(MessageConstant.VALIDATE_PARAMETER_ERROR), null);
	}

	public static Resp failure(String message) {
		return new Resp(MessageConstant.VALIDATE_PARAMETER_ERROR, message, null);
	}

	public static Resp failure(String message, Object data) {
		return new Resp(MessageConstant.VALIDATE_PARAMETER_ERROR, message, data);
	}

	public static Resp failure(String code, String message) {
		return new Resp(code, message, null);
	}

	public static Resp error() {
		return new Resp(MessageConstant.SERVER_ERROR, PropertiesUtil.getMessage(MessageConstant.SERVER_ERROR),
				null);
	}

	public static Resp error(String message) {
		return new Resp(MessageConstant.SERVER_ERROR, message, null);
	}

	public static Resp error(String message, Object data) {
		return new Resp(MessageConstant.SERVER_ERROR, message, data);
	}

	public static Resp error(String code, String message) {
		return new Resp(code, message, null);
	}

	@Override
	public String toString() {
		return "Resp [code=" + code + ", message=" + message + ", data=" + data + "]";
	}
}
