package com.simm.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.util.StringUtils;

/**
 * 
 * @Description 数组工具类
 *
 * @author YingJH
 * @Date 2018年1月26日
 * @version v1.0
 */
public class ArrayUtil {

	/**
	 * 
	 * @Description 判断数组是否为空,空：返回true,否则返回false
	 *
	 * @author YingJH
	 * @Date 2018年1月26日
	 * @param arrays
	 * @return
	 */
	public static boolean isEmpty(Object[] arrays){
		if(arrays == null || arrays.length ==0)
			return true;
		return false;
	}
	
	/**
	 * 
	 * @Description 判断数组是否不为空,空：返回false,否则返回true
	 *
	 * @author YingJH
	 * @Date 2018年1月26日
	 * @param arrays
	 * @return
	 */
	public static boolean isNotEmpty(Object[] arrays){
		return !isEmpty(arrays);
	}
	
	/**
     * 判断集合是否为空
     * 
     * @param list
     *            集合
     */
	@SuppressWarnings("rawtypes")
	public static boolean isEmpty(List list) {
        if (list != null && list.size() > 0) {
            return false;
        } else {
            return true;
        }
    }
	
	/**
     * 判断集合是否不为空
     * 
     * @param list
     *            集合
     */
	@SuppressWarnings("rawtypes")
	public static boolean isNotEmpty(List list) {
        if (list != null && list.size() > 0) {
            return true;
        } else {
            return false;
        }
    }
	
	public static String array2String(Object[] array) {
		String reStr;

		reStr = "";
		if (null != array && StringUtils.hasLength(reStr = Arrays.toString(array))) {
			reStr = reStr.substring(1, reStr.length() - 1);
		}

		return reStr;
	}

	public static List<Integer> array2Integer(Object[] array) {
		List<Integer> reInt;

		reInt = null;
		if (null != array && array.length > 0) {
			reInt = new ArrayList<Integer>();
			for (Object obj : array) {
				if (null != obj) {
					try {
						reInt.add(Integer.parseInt(obj.toString()));
					} catch (Exception e) {
						continue;
					}
				}
			}
		}

		return reInt;
	}

	/**
	 * 判断字符串是否存在数组中
	 * 
	 * @param strs
	 * @param str
	 * @return
	 */
	public static boolean in_array(String[] strs, String str) {

		if (null == strs || strs.length <= 0 || null == str || str.length() <= 0) {
			return false;
		}

		for (String s : strs) {
			if (null != s && s.length() > 0) {
				if (s.equalsIgnoreCase(str)) {
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * 判断字符串是否存在数组中
	 * 
	 * @param strs
	 * @param str
	 * @return
	 */
	public static boolean in_array(Object[] objs, Object obj) {

		if (null == objs || objs.length <= 0 || null == obj) {
			return false;
		}

		for (Object o : objs) {
			if (null != o && o == obj) {
				return true;
			}
		}

		return false;
	}

	/**
	 * 判断字符串是否存在数组中
	 * 
	 * @param strs
	 * @param str
	 * @return
	 */
	public static boolean in_array(String[] strs, String str, boolean ignoreCase) {

		if (null == strs || strs.length <= 0 || null == str || str.length() <= 0) {
			return false;
		}

		for (String s : strs) {
			if (null != s && s.length() > 0) {
				if (ignoreCase) {
					if (s.equalsIgnoreCase(str)) {
						return true;
					}
				} else {
					if (s.equals(str)) {
						return true;
					}
				}
			}
		}

		return false;
	}

	/**
	 * 判断数字是否存在数组中
	 * 
	 * @param strs
	 * @param str
	 * @return
	 */
	public static boolean in_array(Integer[] is, int i) {

		if (null == is || is.length <= 0) {
			return false;
		}

		for (int _i : is) {
			if (_i == i) {
				return true;
			}
		}

		return false;
	}

	/**
	 * list 转 int arr
	 * 
	 * @param list
	 * @return
	 */
	public static Integer[] list2IntegerArray(List<Integer> list) {
		if (null == list || list.size() <= 0)
			return null;
		Integer[] reArr;
		reArr = new Integer[list.size()];
		for (int i = 0; i < list.size(); i++) {
			reArr[i] = list.get(i);
		}

		return reArr;
	}
	
	/** 
	* 按指定大小，分隔集合，将集合按规定个数分为n个部分 
	* @param list 
	* @param len 
	* @return 
	*/ 
	public static List<List<?>> splitList(List<?> list, int len){
		if(list==null || list.size() == 0){
			return null;
		}
		List<List<?>> result =new ArrayList<List<?>>();
		int size = list.size();
		int count = (size + len - 1) / len;
		for (int i = 0; i < count; i++) {
			List<?> subList = list.subList(i * len, ((i + 1) * len > size ? size : len * (i + 1)));
			result.add(subList);
		}
		return result;
		
	}
}