/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import com.simm.common.utils.MySecureProtocolSocketFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang3.StringUtils;

public class HttpUtil {
    public static String HttpConnect(String urlString) {
        return HttpUtil.HttpConnect(urlString, null, HttpMethodEnum.GET, HttpContentTypeEnum.JSON, CharSetEnum.UTF8);
    }

    public static String HttpConnect(String urlString, String param, HttpMethodEnum hmEnum) {
        return HttpUtil.HttpConnect(urlString, param, hmEnum, HttpContentTypeEnum.JSON, CharSetEnum.UTF8);
    }

    public static String HttpConnect(String urlString, String param, HttpMethodEnum hmEnum, HttpContentTypeEnum hctEnum) {
        return HttpUtil.HttpConnect(urlString, param, hmEnum, HttpContentTypeEnum.JSON, CharSetEnum.UTF8);
    }

    public static String HttpConnect(String urlString, String param, HttpMethodEnum hmEnum, CharSetEnum csEnum) {
        return HttpUtil.HttpConnect(urlString, param, hmEnum, HttpContentTypeEnum.JSON, CharSetEnum.UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String HttpConnect(String urlString, String param, HttpMethodEnum hmEnum, HttpContentTypeEnum hctEnum, CharSetEnum csEnum) {
        GetMethod httpMethod = null;
        try {
            if (urlString.toLowerCase().indexOf("https") != -1) {
                MySecureProtocolSocketFactory fcty = new MySecureProtocolSocketFactory();
                Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)fcty, 443));
            }
            HttpClient httpclient = new HttpClient();
            if (hmEnum.equals((Object)HttpMethodEnum.GET)) {
                httpMethod = new GetMethod(urlString);
                httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            } else if (hmEnum.equals((Object)HttpMethodEnum.POST)) {
                httpMethod = new PostMethod(urlString);
                StringRequestEntity requestEntity = new StringRequestEntity(param, hctEnum.getValue(), csEnum.getValue());
                ((PostMethod)httpMethod).setRequestEntity((RequestEntity)requestEntity);
            }
            if (null != httpMethod) {
                int statusCode = httpclient.executeMethod((HttpMethod)httpMethod);
                if (statusCode == 200) {
                    String string = new String(httpMethod.getResponseBody(), "UTF-8");
                    return string;
                }
                throw new Exception(statusCode + "---->" + httpMethod.getStatusLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpMethod) {
                httpMethod.releaseConnection();
            }
        }
        return null;
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (StringUtils.isEmpty((CharSequence)ip)) {
            ip = ip.split(",")[0];
        }
        return ip;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null && "XMLHttpRequest".equals(request.getHeader("X-Requested-With").toString());
    }

    public static enum CharSetEnum {
        UTF8("UTF-8"),
        GBK("GBK"),
        GB2312("GB2312");

        private final String value;

        private CharSetEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum HttpContentTypeEnum {
        JSON("application/json"),
        TEXT("");

        private final String value;

        private HttpContentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum HttpMethodEnum {
        POST,
        GET;

    }
}

