/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.IOUtils;

public class SFTPUtil {
    private ChannelSftp sftp;
    private Session session;
    private String username;
    private String password;
    private String host;
    private int port;
    private String privateKey;

    public static SFTPUtil bulidSFTPUtil(String username, String password, String host, Integer port) {
        return new SFTPUtil(username, password, host, port);
    }

    public SFTPUtil(String username, String password, String host, int port) {
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public SFTPUtil(String username, String host, int port, String privateKey) {
        this.username = username;
        this.host = host;
        this.port = port;
        this.privateKey = privateKey;
    }

    public SFTPUtil() {
    }

    public void login() {
        try {
            JSch jsch = new JSch();
            if (this.privateKey != null) {
                jsch.addIdentity(this.privateKey);
            }
            this.session = jsch.getSession(this.username, this.host, this.port);
            if (this.password != null) {
                this.session.setPassword(this.password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("userauth.gssapi-with-mic", "no");
            this.session.setConfig(config);
            this.session.connect();
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.sftp = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    public void upload(String basePath, String directory, String sftpFileName, InputStream input) throws SftpException {
        try {
            this.sftp.cd(basePath);
            this.sftp.cd(directory);
        }
        catch (SftpException e) {
            String[] dirs = directory.split("/");
            String tempPath = basePath;
            for (String dir : dirs) {
                if (null == dir || "".equals(dir)) continue;
                tempPath = tempPath + "/" + dir;
                try {
                    this.sftp.cd(tempPath);
                }
                catch (SftpException ex) {
                    this.sftp.mkdir(tempPath);
                    this.sftp.cd(tempPath);
                }
            }
        }
        this.sftp.put(input, sftpFileName);
    }

    public void download(String directory, String downloadFile, String saveFile) throws SftpException, FileNotFoundException {
        if (directory != null && !"".equals(directory)) {
            this.sftp.cd(directory);
        }
        File file = new File(saveFile);
        this.sftp.get(downloadFile, (OutputStream)new FileOutputStream(file));
    }

    public byte[] download(String directory, String downloadFile) throws SftpException, IOException {
        if (directory != null && !"".equals(directory)) {
            this.sftp.cd(directory);
        }
        InputStream is = this.sftp.get(downloadFile);
        byte[] fileData = IOUtils.toByteArray((InputStream)is);
        return fileData;
    }

    public void delete(String directory, String deleteFile) throws SftpException {
        this.sftp.cd(directory);
        this.sftp.rm(deleteFile);
    }

    public Vector<?> listFiles(String directory) throws SftpException {
        return this.sftp.ls(directory);
    }
}

