/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils;

import com.simm.common.utils.LinkedStack;
import com.simm.common.utils.LogicUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String ENC_UTF8 = "UTF-8";
    public static final String ENC_GBK = "GBK";
    public static final Charset GBK = Charset.forName("GBK");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String FMT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String EMPTY = "";

    public static String getStringRandom(int length) {
        String val = EMPTY;
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    public static String formatLogger(String[] dataKey, Object[] dataValue) {
        try {
            if (dataKey == null || dataValue == null) {
                return EMPTY;
            }
            if (dataKey.length != dataValue.length) {
                return EMPTY;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < dataKey.length; ++i) {
                stringBuffer.append(dataKey[i]).append("=");
                stringBuffer.append(dataValue[i]);
                if (dataKey.length - 1 == i) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY;
        }
    }

    public static String abandonStartEndStr(String str) {
        if (str == null || "null".equals(str) || EMPTY.equals(str) || String.valueOf(str).length() < 2) {
            return EMPTY;
        }
        return str.toString().substring(1, str.toString().length() - 1);
    }

    public static String abandonStartEndStr(String str, String sub) {
        if (str == null || "null".equals(str) || EMPTY.equals(str)) {
            return EMPTY;
        }
        if (0 == str.indexOf(sub)) {
            str = str.substring(1);
        }
        if (str.length() - 1 == str.lastIndexOf(sub)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String encodeWML(String str) {
        if (str == null) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '$': 
                case '\u00ff': 
                case '\u200b': 
                case '\ufeff': {
                    continue block10;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '\t': {
                    sb.append("  ");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block10;
                }
                case '\n': {
                    sb.append("<br/>");
                    continue block10;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\ue000' && c <= '\uf8ff' || c >= '\ufff0' && c <= '\uffff') continue block10;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String decodeNetUnicode(String str) {
        if (str == null) {
            return null;
        }
        String pStr = "&#(\\d+);";
        Pattern p = Pattern.compile(pStr);
        Matcher m = p.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String mcStr = m.group(1);
            int charValue = StringUtil.convertInt(mcStr, -1);
            String s = charValue > 0 ? (char)charValue + EMPTY : EMPTY;
            m.appendReplacement(sb, Matcher.quoteReplacement(s));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String encodeSQL(String sql) {
        if (sql == null) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\'': {
                    sb.append("''");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\u200b': 
                case '\ufeff': {
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String removeInvalidWML(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0000' && c <= '\u001f' || c >= '\ue000' && c <= '\uf8ff' || c >= '\ufff0' && c <= '\uffff') continue;
            switch (c) {
                case '$': 
                case '\u00ff': 
                case '\u200b': 
                case '\ufeff': {
                    continue block10;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '\t': {
                    sb.append("  ");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block10;
                }
                case '^': 
                case '`': {
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String safeRemoveInvalidWML(String str) {
        return StringUtil.safeRemoveInvalidWML(str, true);
    }

    public static String safeRemoveInvalidWML(String str, boolean removePrivateUseArea) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length() + 48);
        int len = str.length();
        block11: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isHighSurrogate(c)) {
                int codePoint = str.codePointAt(i);
                if (codePoint == c) continue;
                if (!StringUtil.isXMLCharacter(codePoint)) {
                    ++i;
                    continue;
                }
                if (removePrivateUseArea && (codePoint >= 983040 && codePoint <= 1048573 || codePoint >= 0x100000 && codePoint <= 1114109)) {
                    ++i;
                    continue;
                }
                ++i;
                sb.appendCodePoint(codePoint);
                continue;
            }
            if (!StringUtil.isXMLCharacter(c) || removePrivateUseArea && c >= '\ue000' && c <= '\uf8ff' || removePrivateUseArea && c == '\u202e') continue;
            switch (c) {
                case '&': {
                    if (str.startsWith("&amp;amp;", i)) {
                        sb.append("&amp;");
                        i += 8;
                        continue block11;
                    }
                    if (str.startsWith("&amp;gt;", i)) {
                        sb.append("&gt;");
                        i += 7;
                        continue block11;
                    }
                    if (str.startsWith("&amp;lt;", i)) {
                        sb.append("&lt;");
                        i += 7;
                        continue block11;
                    }
                    if (str.startsWith("&amp;apos;", i)) {
                        sb.append("&apos;");
                        i += 9;
                        continue block11;
                    }
                    if (str.startsWith("&amp;quot;", i)) {
                        sb.append("&quot;");
                        i += 9;
                        continue block11;
                    }
                    if (str.startsWith("&amp;", i)) {
                        sb.append("&amp;");
                        i += 4;
                        continue block11;
                    }
                    if (str.startsWith("&gt;", i)) {
                        sb.append("&gt;");
                        i += 3;
                        continue block11;
                    }
                    if (str.startsWith("&lt;", i)) {
                        sb.append("&lt;");
                        i += 3;
                        continue block11;
                    }
                    if (str.startsWith("&apos;", i)) {
                        sb.append("&apos;");
                        i += 5;
                        continue block11;
                    }
                    if (str.startsWith("&quot;", i)) {
                        sb.append("&quot;");
                        i += 5;
                        continue block11;
                    }
                    if (str.startsWith("&#", i)) {
                        int index = -1;
                        for (int j = i + 2; j < i + 10 && j < len; ++j) {
                            char cc = str.charAt(j);
                            if (cc != ';') continue;
                            index = j;
                            break;
                        }
                        if (index > i + 2) {
                            String unicodeVal = str.substring(i + 2, index);
                            try {
                                int val = Integer.parseInt(unicodeVal.substring(1), 'x' == unicodeVal.charAt(0) ? 16 : 10);
                                if (!StringUtil.isXMLCharacter(val)) {
                                    sb.append("&amp;");
                                    continue block11;
                                }
                                sb.append("&#").append(unicodeVal).append(';');
                                i = i + 2 + unicodeVal.length();
                            }
                            catch (Exception e) {
                                sb.append("&amp;");
                            }
                            continue block11;
                        }
                        sb.append("&amp;");
                        continue block11;
                    }
                    sb.append("&amp;");
                    continue block11;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block11;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block11;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block11;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block11;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case '$': {
                    sb.append("&#").append((int)c).append(';');
                    continue block11;
                }
                case '\u200b': 
                case '\ufeff': {
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String removeInvalidXmlChar(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        int len = str.length();
        for (int k = 0; k < len; ++k) {
            char c = str.charAt(k);
            if (StringUtil.isXMLCharacter(c)) continue;
            StringBuilder sb = new StringBuilder(str.length() + 48);
            sb.append(str, 0, k);
            for (int i = k; i < len; ++i) {
                c = str.charAt(i);
                if (Character.isHighSurrogate(c)) {
                    int codePoint = str.codePointAt(i);
                    if (codePoint == c) continue;
                    if (!StringUtil.isXMLCharacter(codePoint)) {
                        ++i;
                        continue;
                    }
                    ++i;
                    sb.appendCodePoint(codePoint);
                    continue;
                }
                if (!StringUtil.isXMLCharacter(c)) continue;
                sb.append(c);
            }
            return sb.toString();
        }
        return str;
    }

    public static String decodeWML(String str) {
        return StringUtil.decodeWML(str, true);
    }

    public static String decodeWML(String str, boolean removePrivateUseArea) {
        if (str == null || str.isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int len = str.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isHighSurrogate(c)) {
                int codePoint = str.codePointAt(i);
                if (codePoint == c) continue;
                if (!StringUtil.isXMLCharacter(codePoint)) {
                    ++i;
                    continue;
                }
                if (removePrivateUseArea && (codePoint >= 983040 && codePoint <= 1048573 || codePoint >= 0x100000 && codePoint <= 1114109)) {
                    ++i;
                    continue;
                }
                ++i;
                sb.appendCodePoint(codePoint);
                continue;
            }
            if (!StringUtil.isXMLCharacter(c) || removePrivateUseArea && c >= '\ue000' && c <= '\uf8ff' || removePrivateUseArea && c == '\u202e') continue;
            switch (c) {
                case '&': {
                    if (str.startsWith("&amp;amp;", i)) {
                        sb.append("&");
                        i += 8;
                        continue block5;
                    }
                    if (str.startsWith("&amp;gt;", i)) {
                        sb.append(">");
                        i += 7;
                        continue block5;
                    }
                    if (str.startsWith("&amp;lt;", i)) {
                        sb.append("<");
                        i += 7;
                        continue block5;
                    }
                    if (str.startsWith("&amp;apos;", i)) {
                        sb.append("'");
                        i += 9;
                        continue block5;
                    }
                    if (str.startsWith("&amp;quot;", i)) {
                        sb.append("\"");
                        i += 9;
                        continue block5;
                    }
                    if (str.startsWith("&amp;nbsp;", i)) {
                        sb.append(" ");
                        i += 9;
                        continue block5;
                    }
                    if (str.startsWith("&amp;", i)) {
                        sb.append("&");
                        i += 4;
                        continue block5;
                    }
                    if (str.startsWith("&gt;", i)) {
                        sb.append(">");
                        i += 3;
                        continue block5;
                    }
                    if (str.startsWith("&lt;", i)) {
                        sb.append("<");
                        i += 3;
                        continue block5;
                    }
                    if (str.startsWith("&apos;", i)) {
                        sb.append("'");
                        i += 5;
                        continue block5;
                    }
                    if (str.startsWith("&quot;", i)) {
                        sb.append("\"");
                        i += 5;
                        continue block5;
                    }
                    if (str.startsWith("&nbsp;", i)) {
                        sb.append(" ");
                        i += 5;
                        continue block5;
                    }
                    if (str.startsWith("&#", i)) {
                        int index = -1;
                        for (int j = i + 2; j < i + 10 && j < len; ++j) {
                            char cc = str.charAt(j);
                            if (cc != ';') continue;
                            index = j;
                            break;
                        }
                        if (index > i + 2) {
                            String unicodeVal = str.substring(i + 2, index);
                            try {
                                int val;
                                boolean hex = 'x' == unicodeVal.charAt(0);
                                int n = val = hex ? Integer.parseInt(unicodeVal.substring(1), 16) : Integer.parseInt(unicodeVal, 10);
                                if (!StringUtil.isXMLCharacter(val)) {
                                    sb.append("&");
                                    continue block5;
                                }
                                if (removePrivateUseArea) {
                                    if (!(val == 8238 || val >= 57344 && val <= 63743 || val >= 983040 && val <= 1048573 || val >= 0x100000 && val <= 1114109)) {
                                        sb.appendCodePoint(val);
                                    }
                                } else {
                                    sb.appendCodePoint(val);
                                }
                                i = i + 2 + unicodeVal.length();
                            }
                            catch (Exception e) {
                                sb.append("&");
                            }
                            continue block5;
                        }
                        sb.append("&");
                        continue block5;
                    }
                    sb.append("&");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isXMLCharacter(int c) {
        if (c == 10) {
            return true;
        }
        if (c == 13) {
            return true;
        }
        if (c == 9) {
            return true;
        }
        if (c < 32) {
            return false;
        }
        if (c <= 55295) {
            return true;
        }
        if (c < 57344) {
            return false;
        }
        if (c <= 65533) {
            return true;
        }
        if (c < 65536) {
            return false;
        }
        return c <= 0x10FFFF;
    }

    public static String convertString(String str, String defaults) {
        if (str == null) {
            return defaults;
        }
        return str;
    }

    public static int convertInt(String str, int defaults) {
        if (str == null) {
            return defaults;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static long convertLong(String str, long defaults) {
        if (str == null) {
            return defaults;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static double convertDouble(String str, double defaults) {
        if (str == null) {
            return defaults;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static short convertShort(String str, short defaults) {
        if (str == null) {
            return defaults;
        }
        try {
            return Short.parseShort(str);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static float convertFloat(String str, float defaults) {
        if (str == null) {
            return defaults;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static boolean convertBoolean(String str, boolean defaults) {
        if (str == null) {
            return defaults;
        }
        try {
            return Boolean.parseBoolean(str);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static String[] split(String line, String seperator) {
        if (line == null || seperator == null || seperator.length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int pos1 = 0;
        while (true) {
            int pos2;
            if ((pos2 = line.indexOf(seperator, pos1)) < 0) break;
            list.add(line.substring(pos1, pos2));
            pos1 = pos2 + seperator.length();
        }
        list.add(line.substring(pos1));
        for (int i = list.size() - 1; i >= 0 && ((String)list.get(i)).length() == 0; --i) {
            list.remove(i);
        }
        return list.toArray(new String[0]);
    }

    public static int[] splitInt(String line, String seperator, int def) {
        String[] ss = StringUtil.split(line, seperator);
        int[] r = new int[ss.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = StringUtil.convertInt(ss[i], def);
        }
        return r;
    }

    public static long[] splitLong(String line, String seperator, long def) {
        String[] ss = StringUtil.split(line, seperator);
        long[] r = new long[ss.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = StringUtil.convertLong(ss[i], def);
        }
        return r;
    }

    public static String join(String separator, Collection c) {
        if (c.isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = c.iterator();
        sb.append(i.next());
        while (i.hasNext()) {
            sb.append(separator);
            sb.append(i.next());
        }
        return sb.toString();
    }

    public static String join(String separator, String[] s) {
        return StringUtil.joinArray(separator, s);
    }

    public static String joinArray(String separator, Object[] s) {
        if (s == null || s.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(s[0]);
        for (int i = 1; i < s.length; ++i) {
            if (s[i] == null) continue;
            sb.append(separator);
            sb.append(s[i].toString());
        }
        return sb.toString();
    }

    public static String joinArray(String separator, int[] s) {
        if (s == null || s.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(s[0]);
        for (int i = 1; i < s.length; ++i) {
            sb.append(separator);
            sb.append(s[i]);
        }
        return sb.toString();
    }

    public static String joinArray(String separator, long[] s) {
        if (s == null || s.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(s[0]);
        for (int i = 1; i < s.length; ++i) {
            sb.append(separator);
            sb.append(s[i]);
        }
        return sb.toString();
    }

    public static String join(String separator, Object ... c) {
        return StringUtil.joinArray(separator, c);
    }

    public static String replaceAll(String s, String src, String dest) {
        if (s == null || src == null || dest == null || src.length() == 0) {
            return s;
        }
        int pos = s.indexOf(src);
        if (pos < 0) {
            return s;
        }
        int capacity = dest.length() > src.length() ? s.length() * 2 : s.length();
        StringBuilder sb = new StringBuilder(capacity);
        int writen = 0;
        while (pos >= 0) {
            sb.append(s, writen, pos);
            sb.append(dest);
            writen = pos + src.length();
            pos = s.indexOf(src, writen);
        }
        sb.append(s, writen, s.length());
        return sb.toString();
    }

    public static String replaceFirst(String s, String src, String dest) {
        if (s == null || src == null || dest == null || src.length() == 0) {
            return s;
        }
        int pos = s.indexOf(src);
        if (pos < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() - src.length() + dest.length());
        sb.append(s, 0, pos);
        sb.append(dest);
        sb.append(s, pos + src.length(), s.length());
        return sb.toString();
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtil.isEmpty(s);
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String removeAll(String s, String src) {
        return StringUtil.replaceAll(s, src, EMPTY);
    }

    public static String joinStr(String str) {
        if (str == null) {
            return null;
        }
        if (EMPTY.equals(str.trim())) {
            return EMPTY;
        }
        String[] split = str.split(",");
        StringBuffer sb = new StringBuffer();
        for (String s : split) {
            if (!StringUtil.isNotBlank(s)) continue;
            sb.append(s).append(",");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    public static String abbreviate(String src, int maxlen, String replacement) {
        if (src == null) {
            return EMPTY;
        }
        if (replacement == null) {
            replacement = EMPTY;
        }
        StringBuffer dest = new StringBuffer();
        try {
            int i;
            if ((maxlen -= StringUtil.computeDisplayLen(replacement)) < 0) {
                return src;
            }
            for (i = 0; i < src.length() && maxlen > 0; ++i) {
                char c = src.charAt(i);
                maxlen = c >= '\u0000' && c <= '\u00ff' ? --maxlen : (maxlen -= 2);
                if (maxlen < 0) continue;
                dest.append(c);
            }
            if (i < src.length() - 1) {
                dest.append(replacement);
            }
            return dest.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return src;
        }
    }

    public static String abbreviate(String src, int maxlen) {
        return StringUtil.abbreviate(src, maxlen, EMPTY);
    }

    public static String toShort(String str, int maxLen, String replacement) {
        if (str == null) {
            return EMPTY;
        }
        if (str.length() <= maxLen) {
            return str;
        }
        StringBuilder dest = new StringBuilder();
        double len = 0.0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            len = c >= '\u0000' && c <= '\u00ff' ? (len += 0.5) : (len += 1.0);
            if (len > (double)maxLen) {
                return dest.toString() + replacement;
            }
            dest.append(c);
        }
        return dest.toString();
    }

    public static String toShort(String str, int maxLen) {
        return StringUtil.toShort(str, maxLen, "...");
    }

    public static int computeDisplayLen(String s) {
        int len = 0;
        if (s == null) {
            return len;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                ++len;
                continue;
            }
            len += 2;
        }
        return len;
    }

    public static byte[] getUTF8Bytes(String s) {
        if (s != null && s.length() >= 0) {
            return s.getBytes(UTF_8);
        }
        return null;
    }

    public static byte[] getGBKBytes(String s) {
        if (s != null && s.length() >= 0) {
            return s.getBytes(GBK);
        }
        return null;
    }

    public static String getUTF8String(byte[] b) {
        if (b != null) {
            return new String(b, UTF_8);
        }
        return null;
    }

    public static String getGBKString(byte[] b) {
        if (b != null) {
            return new String(b, GBK);
        }
        return null;
    }

    public static String urlEncodeGBK(String s) {
        if (s != null && s.length() > 0) {
            try {
                return URLEncoder.encode(s, ENC_GBK);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String urlEncodeUTF8(String s) {
        if (s != null && s.length() > 0) {
            try {
                return URLEncoder.encode(s, ENC_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String urlDecodeGBK(String s) {
        if (s != null && s.length() > 0) {
            try {
                return URLDecoder.decode(s, ENC_GBK);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String urlDecodeUTF8(String s) {
        if (s != null && s.length() > 0) {
            try {
                return URLDecoder.decode(s, ENC_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static char getChar(int i) {
        return (char)(64 + i);
    }

    public static String charsFillSeats(Long character, int size) {
        StringBuffer sb = new StringBuffer();
        int num = Integer.parseInt(character + EMPTY);
        sb.append(num);
        for (int i = String.valueOf(num).length(); i < size; ++i) {
            sb.insert(0, "0");
        }
        return sb.toString();
    }

    public static int compare(String str1, String str2) {
        if (StringUtil.isEmpty(str1) && StringUtil.isEmpty(str2)) {
            return 0;
        }
        if (StringUtil.isEmpty(str1)) {
            return -1;
        }
        if (StringUtil.isEmpty(str2)) {
            return 1;
        }
        int len1 = str1.length();
        int len2 = str2.length();
        int n = Math.min(len1, len2);
        char[] v1 = str1.toCharArray();
        char[] v2 = str2.toCharArray();
        for (int k = 0; k < n; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static String removeRepeatedBlankChar(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return s.replaceAll("\\s+", " ");
    }

    public static void rTrim(StringBuffer targetStrBuf, String subStr) {
        while (targetStrBuf.lastIndexOf(" ") > -1 && targetStrBuf.lastIndexOf(" ") == targetStrBuf.length() - 1 || targetStrBuf.lastIndexOf("   ") > -1 && targetStrBuf.lastIndexOf("   ") == targetStrBuf.length() - 1) {
            targetStrBuf.delete(targetStrBuf.length() - 1, targetStrBuf.length());
        }
        while (targetStrBuf.lastIndexOf(subStr) > 0 && targetStrBuf.lastIndexOf(subStr) == targetStrBuf.length() - subStr.length()) {
            targetStrBuf.delete(targetStrBuf.lastIndexOf(subStr), targetStrBuf.length());
        }
    }

    public static String concatStringArray(String[] arr, String spliter, boolean ignoreBlankStringInArr) {
        if (arr != null && spliter != null) {
            StringBuilder sb = new StringBuilder(EMPTY);
            boolean flag = false;
            for (int i = 0; i < arr.length; ++i) {
                if (!StringUtil.isNotEmpty(arr[i]) && ignoreBlankStringInArr) continue;
                if (flag) {
                    sb.append(spliter);
                } else {
                    flag = true;
                }
                sb.append(arr[i]);
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Invalid argument.");
    }

    public static boolean isNotBlank(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String parseNullStr(String s) {
        return s == null ? EMPTY : s.trim();
    }

    public static int patternMatch(String text, String pattern) {
        if (text != null && pattern != null) {
            KMP kmp = new KMP(pattern);
            int pos = kmp.match(text);
            if (pos == text.length()) {
                pos = -1;
            }
            return pos;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isChinese(String str) {
        if (null == str) {
            return false;
        }
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (StringUtil.isChinese(c)) continue;
            return false;
        }
        return true;
    }

    public static String html(String content) {
        if (content == null) {
            return EMPTY;
        }
        String html = content;
        html = html.replace("&apos;", "'");
        html = html.replace("&amp;", "&");
        html = html.replace("&quot;", "\"");
        html = html.replace("&nbsp;", " ");
        html = html.replace("&lt;", "<");
        html = html.replace("&gt;", ">");
        return html;
    }

    public static String convertNull(String data) {
        return data == null ? EMPTY : data;
    }

    public static int compareVersion(String version1, String version2) throws Exception {
        if (version1 == null || version2 == null) {
            throw new Exception("compareVersion error:illegal params.");
        }
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    public static String replaceStr(String str, int beginNum, int endNum, String replaceStr) {
        if (str == null) {
            return EMPTY;
        }
        try {
            if (str.length() <= beginNum + endNum) {
                return str;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < str.length(); ++i) {
                if (i < beginNum || i >= str.length() - endNum) {
                    sb.append(str.charAt(i));
                    continue;
                }
                sb.append(replaceStr);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static String joinImgUrl(String serverUrl, String imgUrl) {
        if (StringUtil.isEmpty(serverUrl)) {
            return imgUrl;
        }
        if (StringUtil.isEmpty(imgUrl)) {
            return EMPTY;
        }
        if (imgUrl.contains("http")) {
            return imgUrl;
        }
        return serverUrl + imgUrl;
    }

    public static int getFromWord(String sql) {
        if (LogicUtil.isNullOrEmpty(sql)) {
            return -1;
        }
        LinkedStack<String> stack = new LinkedStack<String>();
        sql = sql.toLowerCase().replaceAll("\t", " ");
        int b = 0;
        int s = 0;
        int f = 0;
        String sel = "select ";
        String frm = "from ";
        s = sql.indexOf(sel, 0);
        if (s > -1) {
            stack.push(sel);
            b = s + sel.length();
        }
        do {
            if ((s = sql.indexOf(sel, b)) < (f = sql.indexOf(frm, b)) && s > 0) {
                stack.push(sel);
                b = s + sel.length();
                continue;
            }
            if (s > f && f > 0) {
                stack.pop();
                b = f + frm.length();
                continue;
            }
            if (s > 0 && f < 0) {
                stack.push(sel);
                b = s + sel.length();
                continue;
            }
            if (s >= 0 || f <= 0) break;
            stack.pop();
            b = f + frm.length();
        } while (!stack.isEmpty());
        return f;
    }

    private static class KMP {
        private final String pattern;
        private final int[] next;

        public KMP(String pattern) {
            this.pattern = pattern;
            int M = pattern.length();
            this.next = new int[M];
            int j = -1;
            for (int i = 0; i < M; ++i) {
                this.next[i] = i == 0 ? -1 : (pattern.charAt(i) != pattern.charAt(j) ? j : this.next[j]);
                while (j >= 0 && pattern.charAt(i) != pattern.charAt(j)) {
                    j = this.next[j];
                }
                ++j;
            }
        }

        public int match(String text) {
            int j;
            int M = this.pattern.length();
            int N = text.length();
            int i = 0;
            for (j = 0; i < N && j < M; ++j, ++i) {
                while (j >= 0 && text.charAt(i) != this.pattern.charAt(j)) {
                    j = this.next[j];
                }
            }
            if (j == M) {
                return i - M;
            }
            return N;
        }
    }
}

