/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PAGE_No = 1;
    public static final int DEFAULT_PAGE_SIZE = 10;
    private List<T> pageData;
    private int pageNo = 1;
    private int pageSize = 10;
    private int dataTotal;
    private int pageTotal;
    private boolean prevPage = false;
    private boolean nextPage = false;
    private int pageNumStart;
    private int pageNumEnd;
    private int showPageNum = 5;

    public PageData() {
    }

    public PageData(int pageNo, int pageSize, int dataTotal) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.dataTotal = dataTotal;
        this.calcPageTotal();
        this.refresh();
        this.setPageNumEnd(this.pageNumEnd);
        this.setPageNumStart(this.pageNumStart);
    }

    public PageData(int pageNo, int pageSize, int dataTotal, List<T> pageData) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.dataTotal = dataTotal;
        this.pageData = pageData;
        this.calcPageTotal();
        this.refresh();
        this.setPageNumEnd(this.pageNumEnd);
        this.setPageNumStart(this.pageNumStart);
    }

    private void calcPageTotal() {
        this.pageTotal = this.dataTotal == 0 ? 0 : (this.dataTotal % this.pageSize == 0 ? this.dataTotal / this.pageSize : this.dataTotal / this.pageSize + 1);
    }

    private void refresh() {
        if (this.pageTotal <= 1) {
            this.prevPage = false;
            this.nextPage = false;
        } else if (this.pageNo == 1) {
            this.prevPage = false;
            this.nextPage = true;
        } else if (this.pageNo == this.pageTotal) {
            this.prevPage = true;
            this.nextPage = false;
        } else {
            this.prevPage = true;
            this.nextPage = true;
        }
    }

    public List<T> getPageData() {
        return this.pageData;
    }

    public void setPageData(List<T> pageData) {
        this.pageData = pageData;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getDataTotal() {
        return this.dataTotal;
    }

    public void setDataTotal(int dataTotal) {
        this.dataTotal = dataTotal;
        this.calcPageTotal();
        this.refresh();
    }

    public int getPageTotal() {
        return this.pageTotal;
    }

    public void setPageTotal(int pageTotal) {
        this.pageTotal = pageTotal;
    }

    public boolean hasPrevPage() {
        return this.prevPage;
    }

    public void setPrevPage(boolean prevPage) {
        this.prevPage = prevPage;
    }

    public boolean hasNextPage() {
        return this.nextPage;
    }

    public void setNextPage(boolean nextPage) {
        this.nextPage = nextPage;
    }

    public int getStartOfPage() {
        if (this.pageNo == 0) {
            this.pageNo = 1;
        }
        return (this.pageNo - 1) * this.pageSize;
    }

    public boolean isPrevPage() {
        return this.prevPage;
    }

    public boolean isNextPage() {
        return this.nextPage;
    }

    private static <T> List<T> subList(List<T> list, int pageNo, int pageSize) {
        pageSize = pageSize <= 0 ? 10 : pageSize;
        pageNo = pageNo <= 0 ? 1 : pageNo;
        int begin = pageSize * (pageNo - 1) > list.size() ? list.size() : pageSize * (pageNo - 1);
        int end = pageSize * pageNo > list.size() ? list.size() : pageSize * pageNo;
        return new ArrayList<T>(list.subList(begin, end));
    }

    public static <T> PageData<T> pageList(List<T> list, int pageNo, int pageSize) {
        List<T> l = PageData.subList(list, pageNo, pageSize);
        return new PageData<T>(pageNo, pageSize, list.size(), l);
    }

    public int getPageNumStart() {
        return this.pageNumStart;
    }

    public void setPageNumStart(int pageNumStart) {
        int halfPage = (int)Math.ceil((double)this.showPageNum / 2.0);
        this.pageNumStart = halfPage >= this.pageNo ? 1 : (this.pageNo + halfPage > this.pageTotal ? (this.pageTotal - this.showPageNum + 1 <= 0 ? 1 : this.pageTotal - this.showPageNum + 1) : this.pageNo - halfPage + 1);
    }

    public int getPageNumEnd() {
        return this.pageNumEnd;
    }

    public void setPageNumEnd(int pageNumEnd) {
        int halfPage = (int)Math.ceil((double)this.showPageNum / 2.0);
        this.pageNumEnd = halfPage >= this.pageNo ? (this.showPageNum > this.pageTotal ? this.pageTotal : this.showPageNum) : (this.pageNo + halfPage >= this.pageTotal ? this.pageTotal : this.pageNo + halfPage);
    }

    public int getShowPageNum() {
        return this.showPageNum;
    }

    public void setShowPageNum(int showPageNum) {
        this.showPageNum = showPageNum;
    }

    public String toString() {
        return String.format("PageParam [p=%s, pageNo=%s, pageSize=%s, dataTotal=%s, pageTotal=%s, prevPage=%s, nextPage=%s, pageNumStart=%s, pageNumEnd=%s]", this.pageData, this.pageNo, this.pageSize, this.dataTotal, this.pageTotal, this.prevPage, this.nextPage, this.pageNumStart, this.pageNumEnd);
    }

    public static void main(String[] args) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("123456");
        l.add("654321");
        PageData p = PageData.pageList(l, 1, 1);
        System.out.println(p);
    }
}

