/*
 * Decompiled with CFR 0.152.
 */
package com.simm.common.utils.page;

import com.simm.common.utils.LogicUtil;
import com.simm.common.utils.StringUtil;
import com.simm.common.utils.page.PageParam;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class})})
public class PageInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(PageInterceptor.class);
    private static final String DIALECT_MYSQL = "mysql";
    private static final String DIALECT_ORACLE = "oracle";
    private static final String DIALECT_SQLSERVER = "sqlserver";
    private static final String DB_TYPE = "dbType";
    private String dbType;

    public Object intercept(Invocation invocation) throws Throwable {
        RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
        StatementHandler delegate = (StatementHandler)ReflectUtil.getFieldValue(handler, "delegate");
        BoundSql boundSql = delegate.getBoundSql();
        Object obj = boundSql.getParameterObject();
        PageParam<?> page = this.getPageParam(obj);
        if (page != null) {
            MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue(delegate, "mappedStatement");
            Connection connection = (Connection)invocation.getArgs()[0];
            String sql = boundSql.getSql();
            this.setTotalRow(page, mappedStatement, connection);
            String pageSql = this.getPageSql(page, sql);
            ReflectUtil.setFieldValue(boundSql, "sql", pageSql);
        }
        return invocation.proceed();
    }

    private PageParam<?> getPageParam(Object obj) {
        if (obj instanceof PageParam) {
            return (PageParam)obj;
        }
        if (obj instanceof HashMap) {
            HashMap map = (HashMap)obj;
            for (Map.Entry e : map.entrySet()) {
                if (!(e.getValue() instanceof PageParam)) continue;
                return (PageParam)e.getValue();
            }
        }
        return null;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.dbType = properties.getProperty(DB_TYPE);
    }

    private String getPageSql(PageParam<?> pageParam, String sql) {
        if (DIALECT_MYSQL.equalsIgnoreCase(this.dbType)) {
            return this.getMysqlPageSql(pageParam, sql);
        }
        if (DIALECT_ORACLE.equalsIgnoreCase(this.dbType)) {
            return this.getOraclePageSql(pageParam, sql);
        }
        if (DIALECT_SQLSERVER.equalsIgnoreCase(this.dbType)) {
            return this.getSqlServerPageSql(pageParam, sql);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalRow(PageParam<?> page, MappedStatement mappedStatement, Connection connection) {
        BoundSql boundSql = mappedStatement.getBoundSql(page);
        String sql = boundSql.getSql();
        String totalRowSql = this.getTotalRowSql(sql);
        List<ParameterMapping> totalRowParams = this.getTotalRowParams(boundSql.getParameterMappings(), totalRowSql);
        BoundSql totalBoundSql = new BoundSql(mappedStatement.getConfiguration(), totalRowSql, totalRowParams, page);
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, page, totalBoundSql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(totalRowSql);
            parameterHandler.setParameters(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int rowTotal = rs.getInt(1);
                page.setDataTotal(rowTotal);
            }
        }
        catch (SQLException e) {
            log.error((Object)"set total row error", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"set total row error", (Throwable)e);
            }
        }
    }

    private String getTotalRowSql(String sql) {
        int f = StringUtil.getFromWord(sql);
        if (f <= 0) {
            return null;
        }
        return "select count(*) " + sql.substring(f);
    }

    private List<ParameterMapping> getTotalRowParams(List<ParameterMapping> parameterMappings, String countSql) {
        int size = parameterMappings.size();
        int count = this.getCount(countSql, "?");
        ArrayList<ParameterMapping> paramMappings = new ArrayList<ParameterMapping>();
        if (size >= count && count > 0) {
            paramMappings.addAll(parameterMappings.subList(size - count, size));
        }
        return paramMappings;
    }

    private int getCount(String str, String key) {
        if (LogicUtil.isNotNullAndEmpty(str) && LogicUtil.isNotNullAndEmpty(key)) {
            int c = 0;
            int b = -1;
            int i = str.indexOf(key, b);
            while (i > -1) {
                ++c;
                b = i + key.length();
                i = str.indexOf(key, b);
            }
            return c;
        }
        return 0;
    }

    private int getStartOfPage(PageParam<?> pageParam) {
        int pageNo = pageParam.getPageNo();
        if (pageNo == 0) {
            pageNo = 1;
        }
        return (pageNo - 1) * pageParam.getPageSize();
    }

    private String getMysqlPageSql(PageParam<?> pageParam, String sql) {
        int offset = this.getStartOfPage(pageParam);
        int pageSize = pageParam.getPageSize();
        return sql + " limit " + offset + "," + pageSize;
    }

    private String getOraclePageSql(PageParam<?> pageParam, String sql) {
        int offset = this.getStartOfPage(pageParam);
        int endrow = pageParam.getPageNo() * pageParam.getPageSize();
        return "select * from (select rownum rn, t.* from (" + sql + ") table1 where rownum <= " + endrow + ") table2 where table2.rn > " + offset;
    }

    private String getSqlServerPageSql(PageParam<?> pageParam, String sql) {
        int offset = this.getStartOfPage(pageParam);
        int pageSize = pageParam.getPageSize();
        return "select top " + pageSize + " from (" + sql + ") table1 where table1.id not in (select top " + offset + " table2.id from (" + sql + ") table2)";
    }

    private static class ReflectUtil {
        private ReflectUtil() {
        }

        public static Object getFieldValue(Object obj, String fieldName) {
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field == null) {
                return null;
            }
            Object result = null;
            try {
                field.setAccessible(true);
                result = field.get(obj);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"illegal argument", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"illegal access", (Throwable)e);
            }
            return result;
        }

        private static Field getField(Object obj, String fieldName) {
            Field field = null;
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return field;
        }

        public static void setFieldValue(Object obj, String fieldName, String fieldValue) {
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field == null) {
                return;
            }
            try {
                field.setAccessible(true);
                field.set(obj, fieldValue);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"illegal argument", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"illegal access", (Throwable)e);
            }
        }
    }
}

