/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.livechat.request;

import com.tinet.clink.core.request.AbstractRequestModel;
import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.livechat.PathEnum;
import com.tinet.clink.livechat.response.ChatQueueStatusResponse;
import java.util.List;

public class ChatQueueStatusRequest
extends AbstractRequestModel<ChatQueueStatusResponse> {
    private List<String> qnos;

    public ChatQueueStatusRequest() {
        super(PathEnum.ChatQueueAgentStatus.value(), HttpMethodType.GET);
    }

    @Override
    public Class<ChatQueueStatusResponse> getResponseClass() {
        return ChatQueueStatusResponse.class;
    }

    public List<String> getQnos() {
        return this.qnos;
    }

    public void setQnos(List<String> qnos) {
        this.qnos = qnos;
        StringBuilder queryString = new StringBuilder();
        if (qnos != null && !qnos.isEmpty()) {
            for (String qno : qnos) {
                queryString.append(qno);
                queryString.append(",");
            }
        }
        this.putQueryParameter("qnos", queryString);
    }

    public String toString() {
        return "ChatQueueAgentStatusRequest{qnos=" + this.qnos + "} " + super.toString();
    }
}

