/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.livechat.request;

import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.livechat.PathEnum;
import com.tinet.clink.livechat.request.stat.AbstractStatRequest;
import com.tinet.clink.livechat.response.SessionStatPeriodResponse;
import java.util.List;
import java.util.stream.Collectors;

public class SessionStatPeriodRequest
extends AbstractStatRequest<SessionStatPeriodResponse> {
    private String startTime;
    private String endTime;
    private List<Integer> contactTypes;
    private Integer periodType;

    public Integer getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(Integer periodType) {
        this.periodType = periodType;
        if (periodType != null) {
            this.putBodyParameter("periodType", periodType);
        }
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
        if (startTime != null) {
            this.putQueryParameter("startTime", startTime);
        }
    }

    public List<Integer> getContactTypes() {
        return this.contactTypes;
    }

    public void setContactTypes(List<Integer> contactTypes) {
        this.contactTypes = contactTypes;
        if (contactTypes != null && contactTypes.size() != 0) {
            this.putQueryParameter("contactTypes", SessionStatPeriodRequest.convertIntegerListToString(contactTypes));
        }
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
        if (endTime != null) {
            this.putQueryParameter("endTime", endTime);
        }
    }

    @Override
    public Class<SessionStatPeriodResponse> getResponseClass() {
        return SessionStatPeriodResponse.class;
    }

    public SessionStatPeriodRequest() {
        super(PathEnum.StatSessionPeriodList.value(), HttpMethodType.POST);
    }

    private static String convertStringListToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().collect(Collectors.joining(","));
    }

    private static String convertIntegerListToString(List<Integer> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

