/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.livechat.request;

import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.livechat.PathEnum;
import com.tinet.clink.livechat.response.StatChatClientWorkQualityResponse;
import com.tinet.clink.ticket.request.stat.AbstractStatRequest;
import java.util.List;
import java.util.stream.Collectors;

public class StatChatClientWorkQualityRequest
extends AbstractStatRequest<StatChatClientWorkQualityResponse> {
    private String startTime;
    private String endTime;
    private boolean sortAsc;
    private List<String> cnos;
    private List<Integer> appType;

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
        if (startTime != null) {
            this.putQueryParameter("startTime", startTime);
        }
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
        if (endTime != null) {
            this.putQueryParameter("endTime", endTime);
        }
    }

    public Boolean getSortAsc() {
        return this.sortAsc;
    }

    public void setSortAsc(Boolean sortAsc) {
        this.sortAsc = sortAsc;
        if (sortAsc != null) {
            this.putQueryParameter("sortAsc", sortAsc);
        }
    }

    public List<String> getCnos() {
        return this.cnos;
    }

    public void setCnos(List<String> cnos) {
        this.cnos = cnos;
        if (cnos != null && cnos.size() != 0) {
            this.putQueryParameter("cnos", StatChatClientWorkQualityRequest.convertStringListToString(cnos));
        }
    }

    public List<Integer> getAppType() {
        return this.appType;
    }

    public void setAppType(List<Integer> appType) {
        this.appType = appType;
        if (appType != null && appType.size() != 0) {
            this.putQueryParameter("appType", StatChatClientWorkQualityRequest.convertIntegerListToString(appType));
        }
    }

    @Override
    public Class<StatChatClientWorkQualityResponse> getResponseClass() {
        return StatChatClientWorkQualityResponse.class;
    }

    public StatChatClientWorkQualityRequest() {
        super(PathEnum.StatChatClientWorkQuality.value(), HttpMethodType.POST);
    }

    private static String convertStringListToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().collect(Collectors.joining(","));
    }

    private static String convertIntegerListToString(List<Integer> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

