/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tinet.clink.openapi.ClientConfiguration;
import com.tinet.clink.openapi.auth.Signer;
import com.tinet.clink.openapi.exceptions.ClientException;
import com.tinet.clink.openapi.exceptions.ServerException;
import com.tinet.clink.openapi.model.ErrorCode;
import com.tinet.clink.openapi.model.OpenapiError;
import com.tinet.clink.openapi.request.AbstractRequestModel;
import com.tinet.clink.openapi.response.ResponseModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;

@Deprecated
public class Client {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static CloseableHttpClient httpClient = null;
    private HttpHost httpHost = null;
    private static int maxRetryNumber = 3;
    private ClientConfiguration configuration = null;
    private static Signer signer = Signer.getSigner();
    private static final ObjectMapper CONTENT_OBJECT_MAPPER = new ObjectMapper();
    private static ConcurrentHashMap<String, HttpHost> httpHostMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Client(ClientConfiguration configuration) {
        this.configuration = configuration;
        if (Objects.isNull(httpClient)) {
            Class<Client> clazz = Client.class;
            // MONITORENTER : com.tinet.clink.openapi.Client.class
            if (Objects.isNull(httpClient)) {
                httpClient = HttpClientBuilder.create().evictIdleConnections(5L, TimeUnit.SECONDS).setRetryHandler(new HttpRequestRetryHandler(){

                    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                        if (executionCount > maxRetryNumber) {
                            return false;
                        }
                        return exception instanceof NoHttpResponseException;
                    }
                }).build();
            }
            // MONITOREXIT : clazz
        }
        if (configuration.getPort() == 80) {
            this.httpHost = this.createHttpHost(configuration.getHost(), Integer.toString(-1), configuration.getScheme());
            return;
        }
        this.httpHost = this.createHttpHost(configuration.getHost(), Integer.toString(configuration.getPort()), configuration.getScheme());
    }

    private HttpHost createHttpHost(String host, String port, String scheme) {
        HttpHost httpHostTemp = httpHostMap.get(host + "_" + port + "_" + scheme);
        if (httpHostTemp == null) {
            httpHostTemp = new HttpHost(host, Integer.parseInt(port), scheme);
            httpHostMap.put(host + "_" + port + "_" + scheme, httpHostTemp);
        }
        return httpHostTemp;
    }

    public <T extends ResponseModel> HttpResponse doAction(AbstractRequestModel<T> request) throws ClientException {
        String uri;
        request.signRequest(signer, this.configuration.getCredentials(), this.configuration.getHost());
        String method = request.httpMethod().toString();
        try {
            uri = "/" + request.getPath() + "/?" + request.generateUri();
        }
        catch (URISyntaxException e) {
            throw new ClientException("SDK", "URI \u9519\u8bef", e);
        }
        BasicHttpEntityEnclosingRequest httpRequest = new BasicHttpEntityEnclosingRequest(method, uri);
        if (request.httpMethod().hasContent()) {
            if (request.isMultipartFormData()) {
                MultipartEntityBuilder builder;
                try {
                    builder = this.getMultipartEntityBuilder(request);
                }
                catch (JsonProcessingException e) {
                    throw new ClientException("SDK", "Multipart\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", e);
                }
                httpRequest.setEntity(builder.build());
            } else {
                StringEntity entity;
                try {
                    entity = new StringEntity(mapper.writeValueAsString(request), ContentType.APPLICATION_JSON);
                }
                catch (JsonProcessingException e) {
                    throw new ClientException("SDK", "StringEntity\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", e);
                }
                httpRequest.setHeader("x-virtual-env", "dev.wangli");
                httpRequest.setEntity((HttpEntity)entity);
            }
        }
        try {
            return httpClient.execute(this.httpHost, (HttpRequest)httpRequest);
        }
        catch (ClientProtocolException e) {
            throw new ClientException("SDK", "SDK \u534f\u8bae\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new ClientException("SDK", "\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25", e);
        }
    }

    private <T extends ResponseModel> MultipartEntityBuilder getMultipartEntityBuilder(AbstractRequestModel<T> request) throws JsonProcessingException {
        Map<String, List<File>> fileMap;
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        builder.setCharset(StandardCharsets.UTF_8);
        Object model = request.getModel();
        if (Objects.nonNull(model)) {
            String modelStr = model instanceof String ? (String)model : mapper.writeValueAsString(model);
            builder.addTextBody("model", modelStr, ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)Consts.UTF_8));
        }
        if (Objects.isNull(fileMap = request.getFileMap())) {
            return builder;
        }
        for (Map.Entry<String, List<File>> entry : fileMap.entrySet()) {
            if (Objects.isNull(entry.getValue()) || entry.getValue().size() == 0) continue;
            for (File file : entry.getValue()) {
                if (Objects.isNull(file) || file.length() == 0L) continue;
                builder.addPart(FormBodyPartBuilder.create((String)entry.getKey(), (ContentBody)new FileBody(file)).build());
            }
        }
        return builder;
    }

    public <T extends ResponseModel> T getResponseModel(AbstractRequestModel<T> request) throws ClientException, ServerException {
        HttpResponse response = null;
        try {
            response = this.doAction(request);
            if (this.isSuccess(response)) {
                T t = this.readResponse(response, request.getResponseClass());
                return t;
            }
            OpenapiError openapiError = this.readError(response);
            ErrorCode errorCode = openapiError.getError();
            if (500 <= openapiError.getHttpStatus()) {
                throw new ServerException(openapiError.getRequestId(), errorCode.getCode(), errorCode.getMessage());
            }
            throw new ClientException(openapiError.getRequestId(), errorCode.getCode(), errorCode.getMessage());
        }
        finally {
            if (response instanceof CloseableHttpResponse) {
                try {
                    ((CloseableHttpResponse)response).close();
                }
                catch (IOException e) {
                    throw new ClientException("SDK", "\u5173\u95edResponse\u6d41\u5931\u8d25", e);
                }
            }
        }
    }

    private boolean isSuccess(HttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        return statusLine != null && statusLine.getStatusCode() < 400;
    }

    private OpenapiError readError(HttpResponse response) throws ClientException, ServerException {
        OpenapiError error = null;
        try {
            error = this.getHttpContentObject(response, OpenapiError.class);
        }
        catch (IOException e) {
            if (response.getStatusLine().getStatusCode() == 503) {
                throw new ServerException("ServiceUnavailable", "\u670d\u52a1\u6682\u65f6\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            throw new ServerException("ServiceUnavailable", "\u670d\u52a1\u8fd4\u56de\u9519\u8bef\u7801\u5f02\u5e38\uff0c[" + response.getStatusLine().getStatusCode() + "]", e);
        }
        error.setHttpStatus(response.getStatusLine().getStatusCode());
        return error;
    }

    private <T extends ResponseModel> T readResponse(HttpResponse response, Class<T> clazz) throws ClientException {
        try {
            return (T)((ResponseModel)this.getHttpContentObject(response, clazz));
        }
        catch (IOException e) {
            throw new ClientException("SDK", "\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u4f46SDK\u8bfb\u53d6\u8fd4\u56de\u7ed3\u679c\u5931\u8d25", e);
        }
    }

    private String getHttpContentString(HttpResponse response) throws IOException {
        InputStream in = response.getEntity().getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        return reader.readLine();
    }

    private <T> T getHttpContentObject(HttpResponse response, Class<T> clazz) throws IOException {
        return (T)CONTENT_OBJECT_MAPPER.readValue(response.getEntity().getContent(), clazz);
    }

    static {
        CONTENT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

