/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffGeneratorFactory;
import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffSequenceGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class QDiffUniGenerator
extends QDiffSequenceGenerator
implements QDiffGeneratorFactory {
    public static final String TYPE = "unified";
    private Map myGeneratorsCache;

    public static void setup() {
        QDiffManager.registerDiffGeneratorFactory(new QDiffUniGenerator(), TYPE);
    }

    public QDiffUniGenerator(Map properties, String header) {
        super(QDiffUniGenerator.initProperties(properties), header);
    }

    private QDiffUniGenerator() {
        super(null, null);
    }

    public void generateDiffHeader(String item, String leftInfo, String rightInfo, Writer output) throws IOException {
        leftInfo = leftInfo == null ? "" : "\t" + leftInfo;
        rightInfo = rightInfo == null ? "" : "\t" + rightInfo;
        this.println("--- " + item + leftInfo, output);
        this.println("+++ " + item + rightInfo, output);
    }

    protected void processBlock(QSequenceDifferenceBlock[] segment, QSequenceLineCache sourceLines, QSequenceLineCache targetLines, String encoding, Writer output) throws IOException {
        int i;
        int gutter = this.getGutter();
        StringBuffer header = new StringBuffer();
        header.append(this.getHunkDelimiter());
        int sourceStartLine = segment[0].getLeftFrom();
        int sourceEndLine = segment[segment.length - 1].getLeftTo();
        int targetStartLine = segment[0].getRightFrom();
        int targetEndLine = segment[segment.length - 1].getRightTo();
        int leftStart = Math.max(sourceStartLine - gutter, 0);
        int rightStart = Math.max(targetStartLine - gutter, 0);
        int leftEnd = Math.min(sourceEndLine + gutter, sourceLines.getLineCount() - 1);
        int rightEnd = Math.min(targetEndLine + gutter, targetLines.getLineCount() - 1);
        if (leftStart + 1 >= 0 && leftEnd - leftStart + 1 >= 0) {
            header.append(" -");
            if (leftStart == 0 && leftEnd < 0) {
                header.append("0,0");
            } else {
                header.append(leftStart + 1);
                if (leftEnd - leftStart + 1 > 1) {
                    header.append(",");
                    header.append(leftEnd - leftStart + 1);
                }
            }
        }
        if (rightStart + 1 > 0 && rightEnd - rightStart + 1 > 0) {
            header.append(" +");
            header.append(rightStart + 1);
            if (rightEnd - rightStart + 1 > 1) {
                header.append(",");
                header.append(rightEnd - rightStart + 1);
            }
        } else {
            header.append(" +0,0");
        }
        header.append(" ");
        header.append(this.getHunkDelimiter());
        this.println(header.toString(), output);
        for (i = leftStart; i < sourceStartLine; ++i) {
            this.print(" " + this.printLine(sourceLines.getLine(i), encoding), output);
        }
        for (i = 0; i < segment.length; ++i) {
            String line;
            int j;
            QSequenceDifferenceBlock block = segment[i];
            for (j = block.getLeftFrom(); j <= block.getLeftTo(); ++j) {
                line = this.printLine(sourceLines.getLine(j), encoding);
                this.print("-" + line, output);
                if (j != sourceLines.getLineCount() - 1) continue;
                this.printNoNewLine(output, line);
            }
            for (j = block.getRightFrom(); j <= block.getRightTo(); ++j) {
                line = this.printLine(targetLines.getLine(j), encoding);
                this.print("+" + line, output);
                if (j != targetLines.getLineCount() - 1) continue;
                this.printNoNewLine(output, line);
            }
            int plannedEnd = i < segment.length - 1 ? segment[i + 1].getLeftFrom() - 1 : block.getLeftTo() + gutter;
            int end = Math.min(plannedEnd, sourceLines.getLineCount() - 1);
            if (i + 1 < segment.length) {
                end = Math.min(end, segment[i + 1].getLeftFrom() - 1);
            }
            for (int j2 = block.getLeftTo() + 1; j2 <= end; ++j2) {
                String line2 = this.printLine(sourceLines.getLine(j2), encoding);
                this.print(" " + this.printLine(sourceLines.getLine(j2), encoding), output);
                if (j2 != sourceLines.getLineCount() - 1) continue;
                this.printNoNewLine(output, line2);
            }
        }
    }

    protected void processBlock(QSequenceDifferenceBlock[] segment, QSequenceLineCache sourceLines, QSequenceLineCache targetLines, OutputStream output) throws IOException {
        int i;
        int gutter = this.getGutter();
        StringBuffer header = new StringBuffer();
        header.append(this.getHunkDelimiter());
        int sourceStartLine = segment[0].getLeftFrom();
        int sourceEndLine = segment[segment.length - 1].getLeftTo();
        int targetStartLine = segment[0].getRightFrom();
        int targetEndLine = segment[segment.length - 1].getRightTo();
        int leftStart = Math.max(sourceStartLine - gutter, 0);
        int rightStart = Math.max(targetStartLine - gutter, 0);
        int leftEnd = Math.min(sourceEndLine + gutter, sourceLines.getLineCount() - 1);
        int rightEnd = Math.min(targetEndLine + gutter, targetLines.getLineCount() - 1);
        if (leftStart + 1 >= 0 && leftEnd - leftStart + 1 >= 0) {
            header.append(" -");
            if (leftStart == 0 && leftEnd < 0) {
                header.append("0,0");
            } else {
                header.append(leftStart + 1);
                if (leftEnd - leftStart + 1 > 1) {
                    header.append(",");
                    header.append(leftEnd - leftStart + 1);
                }
            }
        }
        if (rightStart + 1 > 0 && rightEnd - rightStart + 1 > 0) {
            header.append(" +");
            header.append(rightStart + 1);
            if (rightEnd - rightStart + 1 > 1) {
                header.append(",");
                header.append(rightEnd - rightStart + 1);
            }
        } else {
            header.append(" +0,0");
        }
        header.append(" ");
        header.append(this.getHunkDelimiter());
        this.println(header.toString(), output);
        for (i = leftStart; i < sourceStartLine; ++i) {
            output.write(32);
            output.write(sourceLines.getLine(i).getContentBytes());
        }
        for (i = 0; i < segment.length; ++i) {
            byte[] line;
            int j;
            QSequenceDifferenceBlock block = segment[i];
            for (j = block.getLeftFrom(); j <= block.getLeftTo(); ++j) {
                output.write(45);
                line = sourceLines.getLine(j).getContentBytes();
                output.write(line);
                if (j != sourceLines.getLineCount() - 1) continue;
                this.printNoNewLine(output, line);
            }
            for (j = block.getRightFrom(); j <= block.getRightTo(); ++j) {
                output.write(43);
                line = targetLines.getLine(j).getContentBytes();
                output.write(line);
                if (j != targetLines.getLineCount() - 1) continue;
                this.printNoNewLine(output, line);
            }
            int plannedEnd = i < segment.length - 1 ? segment[i + 1].getLeftFrom() - 1 : block.getLeftTo() + gutter;
            int end = Math.min(plannedEnd, sourceLines.getLineCount() - 1);
            if (i + 1 < segment.length) {
                end = Math.min(end, segment[i + 1].getLeftFrom() - 1);
            }
            for (int j2 = block.getLeftTo() + 1; j2 <= end; ++j2) {
                output.write(32);
                byte[] line2 = sourceLines.getLine(j2).getContentBytes();
                output.write(line2);
                if (j2 != sourceLines.getLineCount() - 1) continue;
                this.printNoNewLine(output, line2);
            }
        }
    }

    public QDiffGenerator createGenerator(Map properties) {
        QDiffGenerator generator;
        if (this.myGeneratorsCache == null) {
            this.myGeneratorsCache = new HashMap();
        }
        if ((generator = (QDiffGenerator)this.myGeneratorsCache.get(properties)) != null) {
            return generator;
        }
        generator = new QDiffUniGenerator(properties, null);
        this.myGeneratorsCache.put(properties, generator);
        return generator;
    }

    private void printNoNewLine(Writer output, String line) throws IOException {
        if (!line.endsWith("\n") && !line.endsWith("\r")) {
            this.println(output);
            this.println("\\ No newline at end of file", output);
        }
    }

    private void printNoNewLine(OutputStream output, byte[] line) throws IOException {
        if (line[line.length - 1] != 10 && line[line.length - 1] != 13) {
            this.println(output);
            this.println("\\ No newline at end of file", output);
        }
    }

    private static Map initProperties(Map properties) {
        if (properties == null || !properties.containsKey("gutter")) {
            properties = new HashMap<String, String>(properties == null ? Collections.EMPTY_MAP : properties);
            properties.put("gutter", "3");
        }
        return properties;
    }
}

