/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons;

import com.google.common.annotations.Beta;
import com.livk.commons.util.ClassUtils;
import com.livk.commons.util.DateUtils;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.env.Environment;

public class SpringLauncher {
    private static volatile SpringApplication application;

    @Beta
    public static ConfigurableApplicationContext run(String[] args) {
        Class mainClass = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).filter(StringUtils::isNotBlank).map(ClassUtils::resolveClassName).filter(type -> type.isAnnotationPresent(SpringBootApplication.class)).findFirst().orElseThrow(() -> new AnnotationConfigurationException(" \u7f3a\u5c11@" + SpringBootApplication.class.getName() + "\u6ce8\u89e3"));
        return SpringLauncher.run(mainClass, args);
    }

    public static ConfigurableApplicationContext run(Class<?> targetClass, String[] args) {
        application = new SpringApplicationBuilder(new Class[]{targetClass}).banner((Banner)CloudBanner.create()).bannerMode(Banner.Mode.CONSOLE).build(args);
        return application.run(args);
    }

    public static String getVersion() {
        Package pkg = SpringLauncher.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    public static SpringApplication application() {
        return application;
    }

    private SpringLauncher() {
    }

    private static class CloudBanner
    implements Banner {
        private static final String banner = " \u2588\u2588       \u2588\u2588          \u2588\u2588         \u2588\u2588\u2588\u2588\u2588\u2588   \u2588\u2588                       \u2588\u2588\n\u2591\u2588\u2588      \u2591\u2591          \u2591\u2588\u2588        \u2588\u2588\u2591\u2591\u2591\u2591\u2588\u2588 \u2591\u2588\u2588                      \u2591\u2588\u2588\n\u2591\u2588\u2588       \u2588\u2588 \u2588\u2588    \u2588\u2588\u2591\u2588\u2588  \u2588\u2588   \u2588\u2588    \u2591\u2591  \u2591\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588   \u2588\u2588     \u2591\u2588\u2588\n\u2591\u2588\u2588      \u2591\u2588\u2588\u2591\u2588\u2588   \u2591\u2588\u2588\u2591\u2588\u2588 \u2588\u2588   \u2591\u2588\u2588        \u2591\u2588\u2588 \u2588\u2588\u2591\u2591\u2591\u2591\u2588\u2588\u2591\u2588\u2588  \u2591\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588\n\u2591\u2588\u2588      \u2591\u2588\u2588\u2591\u2591\u2588\u2588 \u2591\u2588\u2588 \u2591\u2588\u2588\u2588\u2588    \u2591\u2588\u2588        \u2591\u2588\u2588\u2591\u2588\u2588   \u2591\u2588\u2588\u2591\u2588\u2588  \u2591\u2588\u2588 \u2588\u2588\u2591\u2591\u2591\u2588\u2588\n\u2591\u2588\u2588      \u2591\u2588\u2588 \u2591\u2591\u2588\u2588\u2588\u2588  \u2591\u2588\u2588\u2591\u2588\u2588   \u2591\u2591\u2588\u2588    \u2588\u2588 \u2591\u2588\u2588\u2591\u2588\u2588   \u2591\u2588\u2588\u2591\u2588\u2588  \u2591\u2588\u2588\u2591\u2588\u2588  \u2591\u2588\u2588\n\u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2591\u2588\u2588  \u2591\u2591\u2588\u2588   \u2591\u2588\u2588\u2591\u2591\u2588\u2588   \u2591\u2591\u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2591\u2591\u2588\u2588\u2588\u2588\u2588\u2588 \u2591\u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2591\u2591\u2588\u2588\u2588\u2588\u2588\u2588\n\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591 \u2591\u2591    \u2591\u2591    \u2591\u2591  \u2591\u2591     \u2591\u2591\u2591\u2591\u2591\u2591  \u2591\u2591\u2591  \u2591\u2591\u2591\u2591\u2591\u2591   \u2591\u2591\u2591\u2591\u2591\u2591  \u2591\u2591\u2591\u2591\u2591\u2591\n";

        public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
            if (((Boolean)environment.getProperty("spring.banner.enabled", Boolean.class, (Object)true)).booleanValue()) {
                out.println(banner);
                int max = banner.lines().mapToInt(String::length).max().orElse(0);
                new Format(max, out).println(" Spring Version: " + SpringVersion.getVersion() + " ").println(" Spring Boot Version: " + SpringBootVersion.getVersion() + " ").println(" Spring Boot Extension Version: " + SpringLauncher.getVersion() + " ").println(" Current Time: " + DateUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss") + " ").println(" Current JDK Version: " + environment.getProperty("java.version") + " ").println(" Operating System: " + environment.getProperty("os.name") + " ").flush();
            }
        }

        private CloudBanner() {
        }

        public static CloudBanner create() {
            return new CloudBanner();
        }
    }

    private static class Format {
        private static final char ch = '*';
        private final int n;
        private final PrintStream out;

        Format(int max, PrintStream out) {
            this.n = max % 2 == 0 ? max : max + 1;
            this.out = out;
        }

        public Format println(String str) {
            if (!str.contains("null")) {
                int length = str.length();
                if (length < this.n) {
                    int index = this.n - length >> 1;
                    str = StringUtils.leftPad((String)str, (int)(length + index), (char)'*');
                    str = StringUtils.rightPad((String)str, (int)this.n, (char)'*');
                }
                this.out.println(str);
            }
            return this;
        }

        public void flush() {
            this.out.flush();
        }
    }
}

