/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.aop;

import com.google.common.collect.Sets;
import com.livk.commons.aop.AnnotationAutoPointcut;
import com.livk.commons.aop.AnnotationClassOrMethodPointcut;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;

public enum AnnotationPointcutType implements AnnotationAutoPointcut
{
    TYPE(AnnotationMatchingPointcut::forClassAnnotation),
    METHOD(AnnotationMatchingPointcut::forMethodAnnotation),
    TYPE_OR_METHOD(AnnotationClassOrMethodPointcut::new),
    AUTO(annotationType -> {
        Target target = annotationType.getAnnotation(Target.class);
        HashSet elementTypeHashSet = Sets.newHashSet((Object[])target.value());
        if (elementTypeHashSet.contains((Object)ElementType.TYPE) && elementTypeHashSet.contains((Object)ElementType.METHOD)) {
            return TYPE_OR_METHOD.getPointcut(annotationType);
        }
        if (elementTypeHashSet.contains((Object)ElementType.TYPE)) {
            return TYPE.getPointcut(annotationType);
        }
        if (elementTypeHashSet.contains((Object)ElementType.METHOD)) {
            return METHOD.getPointcut(annotationType);
        }
        throw new IllegalArgumentException("annotation:" + String.valueOf(annotationType) + " Missing " + String.valueOf(Target.class) + " TYPE or METHOD information");
    });

    private final AnnotationAutoPointcut annotationAutoPointcut;

    @Override
    public Pointcut getPointcut(Class<? extends Annotation> annotationType) {
        return this.annotationAutoPointcut.getPointcut(annotationType);
    }

    private AnnotationPointcutType(AnnotationAutoPointcut annotationAutoPointcut) {
        this.annotationAutoPointcut = annotationAutoPointcut;
    }
}

