/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.beans;

import com.livk.commons.beans.BeanLambdaFunc;
import com.livk.commons.util.BeanUtils;
import com.livk.commons.util.ClassUtils;
import com.livk.commons.util.Pair;
import com.livk.commons.util.ReflectionUtils;
import java.beans.PropertyDescriptor;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class BeanLambdaDescriptor {
    private static final Map<Pair<Class<?>, String>, BeanLambdaDescriptor> cache = new ConcurrentHashMap(128);
    private final Class<?> type;
    private final String methodName;
    private PropertyDescriptor propertyDescriptor;

    private BeanLambdaDescriptor(Class<?> type, String methodName) {
        this.type = type;
        this.methodName = methodName;
        this.initField();
    }

    public static <T> BeanLambdaDescriptor create(BeanLambdaFunc<T> function) {
        Method writeReplace = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        writeReplace.setAccessible(true);
        SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke(function, new Object[0]);
        String className = ClassUtils.convertResourcePathToClassName((String)serializedLambda.getImplClass());
        Class<?> type = ClassUtils.resolveClassName(className);
        return cache.computeIfAbsent(Pair.of(type, serializedLambda.getImplMethodName()), pair -> new BeanLambdaDescriptor((Class)pair.key(), (String)pair.value()));
    }

    private void initField() {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(this.type)) {
            if (!propertyDescriptor.getReadMethod().getName().equals(this.methodName)) continue;
            this.propertyDescriptor = propertyDescriptor;
        }
    }

    public String getFieldName() {
        return this.propertyDescriptor != null ? this.propertyDescriptor.getName() : null;
    }

    public Field getField() {
        if (this.propertyDescriptor != null) {
            String fieldName = this.getFieldName();
            Class<?> fieldType = this.propertyDescriptor.getPropertyType();
            return ReflectionUtils.findField(this.type, (String)fieldName, fieldType);
        }
        return null;
    }

    public Method getMethod() {
        return ReflectionUtils.findMethod(this.type, (String)this.methodName);
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }
}

