/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.beans;

import com.livk.commons.beans.RecordWrapper;
import com.livk.commons.beans.Wrapper;
import java.util.Optional;
import java.util.function.Function;

public interface GenericWrapper<V>
extends Wrapper {
    public static <T> GenericWrapper<T> of(T delegate) {
        return new RecordWrapper<T>(delegate);
    }

    default public <R> GenericWrapper<R> map(Function<V, R> function) {
        V unwrap = this.unwrap();
        return GenericWrapper.of(function.apply(unwrap));
    }

    default public <R> GenericWrapper<R> flatmap(Function<V, GenericWrapper<R>> function) {
        return function.apply(this.unwrap());
    }

    default public Optional<V> optional() {
        return Optional.of(this).map(GenericWrapper::unwrap);
    }

    public V unwrap();
}

